"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequireApproval = void 0;
/**
 * In what scenarios should the CLI ask for approval
 */
var RequireApproval;
(function (RequireApproval) {
    /**
     * Never ask for approval
     */
    RequireApproval["NEVER"] = "never";
    /**
     * Prompt for approval for any type  of change to the stack
     */
    RequireApproval["ANYCHANGE"] = "any-change";
    /**
     * Only prompt for approval if there are security related changes
     */
    RequireApproval["BROADENING"] = "broadening";
})(RequireApproval = exports.RequireApproval || (exports.RequireApproval = {}));
//# sourceMappingURL=data:application/json;base64,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