"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.attachCustomSynthesis = exports.App = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxapi = require("../../cx-api");
const fs = require("fs-extra");
const private_context_1 = require("./private/private-context");
const synthesis_1 = require("./private/synthesis");
const stage_1 = require("./stage");
const APP_SYMBOL = Symbol.for('@aws-cdk/core.App');
/**
 * A construct which represents an entire CDK app. This construct is normally
 * the root of the construct tree.
 *
 * You would normally define an `App` instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 *
 * After all the child constructs are defined within the app, you should call
 * `app.synth()` which will emit a "cloud assembly" from this app into the
 * directory specified by `outdir`. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 *
 * @see https://docs.aws.amazon.com/cdk/latest/guide/apps.html
 */
class App extends stage_1.Stage {
    /**
     * Checks if an object is an instance of the `App` class.
     * @returns `true` if `obj` is an `App`.
     * @param obj The object to evaluate
     */
    static isApp(obj) {
        return APP_SYMBOL in obj;
    }
    /**
     * Initializes a CDK application.
     * @param props initialization properties
     */
    constructor(props = {}) {
        super(undefined, '', {
            outdir: props.outdir ?? process.env[cxapi.OUTDIR_ENV],
            policyValidationBeta1: props.policyValidationBeta1,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.loadContext(props.context, props.postCliContext);
        if (props.stackTraces === false) {
            this.node.setContext(cxapi.DISABLE_METADATA_STACK_TRACE, true);
        }
        if (props.defaultStackSynthesizer) {
            this.node.setContext(private_context_1.PRIVATE_CONTEXT_DEFAULT_STACK_SYNTHESIZER, props.defaultStackSynthesizer);
        }
        const analyticsReporting = props.analyticsReporting ?? props.runtimeInfo;
        if (analyticsReporting !== undefined) {
            this.node.setContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT, analyticsReporting);
        }
        const autoSynth = props.autoSynth ?? cxapi.OUTDIR_ENV in process.env;
        if (autoSynth) {
            // synth() guarantees it will only execute once, so a default of 'true'
            // doesn't bite manual calling of the function.
            process.once('beforeExit', () => this.synth());
        }
        this._treeMetadata = props.treeMetadata ?? true;
    }
    loadContext(defaults = {}, final = {}) {
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            this.node.setContext(k, v);
        }
        // reconstructing the context from the two possible sources:
        const context = {
            ...this.readContextFromEnvironment(),
            ...this.readContextFromTempFile(),
        };
        for (const [k, v] of Object.entries(context)) {
            this.node.setContext(k, v);
        }
        // finalContext passed through constructor overwrites
        for (const [k, v] of Object.entries(final)) {
            this.node.setContext(k, v);
        }
    }
    readContextFromTempFile() {
        const location = process.env[cxapi.CONTEXT_OVERFLOW_LOCATION_ENV];
        return location ? fs.readJSONSync(location) : {};
    }
    readContextFromEnvironment() {
        const contextJson = process.env[cxapi.CONTEXT_ENV];
        return contextJson ? JSON.parse(contextJson) : {};
    }
}
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "aws-cdk-lib.App", version: "2.74.0" };
exports.App = App;
/**
 * Add a custom synthesis for the given construct
 *
 * When the construct is being synthesized, this allows it to add additional items
 * into the Cloud Assembly output.
 *
 * This feature is intended for use by official AWS CDK libraries only; 3rd party
 * library authors and CDK users should not use this function. That's why it's not
 * exposed via jsii.
 */
function attachCustomSynthesis(construct, synthesis) {
    // synthesis.ts where the implementation lives is not exported. So
    // this function is just a re-export of that function.
    (0, synthesis_1.addCustomSynthesis)(construct, synthesis);
}
exports.attachCustomSynthesis = attachCustomSynthesis;
//# sourceMappingURL=data:application/json;base64,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