"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDeletionPolicy = void 0;
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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