"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lazy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const debug_1 = require("./debug");
const stack_trace_1 = require("./stack-trace");
const token_1 = require("./token");
/**
 * Lazily produce a value
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
class Lazy {
    /**
     * Defer the calculation of a string value to synthesis time
     *
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string` type and don't need
     * the calculation to be deferred, use `Token.asString()` instead.
     *
     * @deprecated Use `Lazy.string()` or `Lazy.uncachedString()` instead.
     */
    static stringValue(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer, false), options);
    }
    /**
     * Defer the one-time calculation of a string value to synthesis time
     *
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string` type and don't need
     * the calculation to be deferred, use `Token.asString()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static string(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IStableStringProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyStringValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.string);
            }
            throw error;
        }
        return token_1.Token.asString(new LazyString(producer, true), options);
    }
    /**
     * Defer the calculation of a string value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.string()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedString(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IStringProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyStringValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.uncachedString);
            }
            throw error;
        }
        return token_1.Token.asString(new LazyString(producer, false), options);
    }
    /**
     * Defer the one-time calculation of a number value to synthesis time
     *
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `number` type and don't need
     * the calculation to be deferred, use `Token.asNumber()` instead.
     *
     * @deprecated Use `Lazy.number()` or `Lazy.uncachedNumber()` instead.
     */
    static numberValue(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer, false));
    }
    /**
     * Defer the one-time calculation of a number value to synthesis time
     *
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `number` type and don't need
     * the calculation to be deferred, use `Token.asNumber()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static number(producer) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IStableNumberProducer(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.number);
            }
            throw error;
        }
        return token_1.Token.asNumber(new LazyNumber(producer, true));
    }
    /**
     * Defer the calculation of a number value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.number()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedNumber(producer) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_INumberProducer(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.uncachedNumber);
            }
            throw error;
        }
        return token_1.Token.asNumber(new LazyNumber(producer, false));
    }
    /**
     * Defer the one-time calculation of a list value to synthesis time
     *
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string[]` type and don't need
     * the calculation to be deferred, use `Token.asList()` instead.
     *
     * @deprecated Use `Lazy.list()` or `Lazy.uncachedList()` instead.
     */
    static listValue(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, false, options), options);
    }
    /**
     * Defer the calculation of a list value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.list()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedList(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IListProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyListValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.uncachedList);
            }
            throw error;
        }
        return token_1.Token.asList(new LazyList(producer, false, options), options);
    }
    /**
     * Defer the one-time calculation of a list value to synthesis time
     *
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string[]` type and don't need
     * the calculation to be deferred, use `Token.asList()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static list(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IStableListProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyListValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.list);
            }
            throw error;
        }
        return token_1.Token.asList(new LazyList(producer, true, options), options);
    }
    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time
     *
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * @deprecated Use `Lazy.any()` or `Lazy.uncachedAny()` instead.
     */
    static anyValue(producer, options = {}) {
        return new LazyAny(producer, false, options);
    }
    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time
     *
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     */
    static any(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IStableAnyProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyAnyValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.any);
            }
            throw error;
        }
        return new LazyAny(producer, true, options);
    }
    /**
     * Defer the calculation of an untyped value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.any()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedAny(producer, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_IAnyProducer(producer);
            jsiiDeprecationWarnings.aws_cdk_lib_LazyAnyValueOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.uncachedAny);
            }
            throw error;
        }
        return new LazyAny(producer, false, options);
    }
    constructor() {
    }
}
_a = JSII_RTTI_SYMBOL_1;
Lazy[_a] = { fqn: "aws-cdk-lib.Lazy", version: "2.74.0" };
exports.Lazy = Lazy;
class LazyBase {
    constructor(producer, cache) {
        this.producer = producer;
        this.cache = cache;
        // Stack trace capture is conditioned to `debugModeEnabled()`, because
        // lazies can be created in a fairly thrashy way, and the stack traces are
        // large and slow to obtain; but are mostly useful only when debugging a
        // resolution issue.
        this.creationStack = (0, debug_1.debugModeEnabled)()
            ? (0, stack_trace_1.captureStackTrace)(this.constructor)
            : [`Execute again with ${debug_1.CDK_DEBUG}=true to capture stack traces`];
    }
    resolve(context) {
        if (this.cache) {
            return this._cached ?? (this._cached = this.producer.produce(context));
        }
        else {
            return this.producer.produce(context);
        }
    }
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        return '<unresolved-lazy>';
    }
}
class LazyString extends LazyBase {
}
class LazyNumber extends LazyBase {
}
class LazyList extends LazyBase {
    constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
    }
    resolve(context) {
        const resolved = super.resolve(context);
        if (resolved?.length === 0 && this.options.omitEmpty) {
            return undefined;
        }
        return resolved;
    }
}
class LazyAny extends LazyBase {
    constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
    }
    resolve(context) {
        const resolved = super.resolve(context);
        if (Array.isArray(resolved) && resolved.length === 0 && this.options.omitEmptyArray) {
            return undefined;
        }
        return resolved;
    }
}
//# sourceMappingURL=data:application/json;base64,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