"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCloudArtifact = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_artifact_1 = require("../cloud-artifact");
class TreeCloudArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly);
            jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TreeCloudArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
    }
}
_a = JSII_RTTI_SYMBOL_1;
TreeCloudArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.TreeCloudArtifact", version: "2.74.0" };
exports.TreeCloudArtifact = TreeCloudArtifact;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS1jbG91ZC1hcnRpZmFjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyZWUtY2xvdWQtYXJ0aWZhY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0Esc0RBQWtEO0FBR2xELE1BQWEsaUJBQWtCLFNBQVEsOEJBQWE7SUFHbEQsWUFBWSxRQUF1QixFQUFFLElBQVksRUFBRSxRQUFtQztRQUNwRixLQUFLLENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLENBQUMsQ0FBQzs7Ozs7OzsrQ0FKdkIsaUJBQWlCOzs7O1FBTTFCLE1BQU0sVUFBVSxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLElBQUksRUFBRSxDQUFvQyxDQUFDO1FBQ3ZGLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFO1lBQ3BCLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztTQUN2RTtRQUNELElBQUksQ0FBQyxJQUFJLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQztLQUM3Qjs7OztBQVhVLDhDQUFpQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGN4c2NoZW1hIGZyb20gJy4uLy4uLy4uL2Nsb3VkLWFzc2VtYmx5LXNjaGVtYSc7XG5pbXBvcnQgeyBDbG91ZEFydGlmYWN0IH0gZnJvbSAnLi4vY2xvdWQtYXJ0aWZhY3QnO1xuaW1wb3J0IHsgQ2xvdWRBc3NlbWJseSB9IGZyb20gJy4uL2Nsb3VkLWFzc2VtYmx5JztcblxuZXhwb3J0IGNsYXNzIFRyZWVDbG91ZEFydGlmYWN0IGV4dGVuZHMgQ2xvdWRBcnRpZmFjdCB7XG4gIHB1YmxpYyByZWFkb25seSBmaWxlOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoYXNzZW1ibHk6IENsb3VkQXNzZW1ibHksIG5hbWU6IHN0cmluZywgYXJ0aWZhY3Q6IGN4c2NoZW1hLkFydGlmYWN0TWFuaWZlc3QpIHtcbiAgICBzdXBlcihhc3NlbWJseSwgbmFtZSwgYXJ0aWZhY3QpO1xuXG4gICAgY29uc3QgcHJvcGVydGllcyA9ICh0aGlzLm1hbmlmZXN0LnByb3BlcnRpZXMgfHwge30pIGFzIGN4c2NoZW1hLlRyZWVBcnRpZmFjdFByb3BlcnRpZXM7XG4gICAgaWYgKCFwcm9wZXJ0aWVzLmZpbGUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignSW52YWxpZCBUcmVlQ2xvdWRBcnRpZmFjdC4gTWlzc2luZyBcImZpbGVcIiBwcm9wZXJ0eScpO1xuICAgIH1cbiAgICB0aGlzLmZpbGUgPSBwcm9wZXJ0aWVzLmZpbGU7XG4gIH1cbn0iXX0=