"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY = exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = 'aws:asset:dockerfile-path';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = 'aws:asset:docker-build-args';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY = 'aws:asset:docker-build-secrets';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = 'aws:asset:docker-build-target';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = 'aws:asset:is-bundled';
exports.ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY = 'aws:asset:docker-outputs';
exports.ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY = 'aws:asset:docker-cache-from';
exports.ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY = 'aws:asset:docker-cache-to';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,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