"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SSMPARAM_NO_INVALIDATE = exports.PROVIDER_ERROR_KEY = exports.CLI_VERSION_ENV = exports.CLI_ASM_VERSION_ENV = exports.DEFAULT_REGION_ENV = exports.DEFAULT_ACCOUNT_ENV = exports.CONTEXT_OVERFLOW_LOCATION_ENV = exports.CONTEXT_ENV = exports.OUTDIR_ENV = void 0;
// output directory into which to emit synthesis outputs. CDK doesn't allow outdir
// to be specified both through the CDK_OUTDIR environment variable and the through
// aws:cdk:outdir context.
exports.OUTDIR_ENV = 'CDK_OUTDIR';
exports.CONTEXT_ENV = 'CDK_CONTEXT_JSON';
/**
 * The name of the temporary file where the context is stored.
 */
exports.CONTEXT_OVERFLOW_LOCATION_ENV = 'CONTEXT_OVERFLOW_LOCATION_ENV';
/**
 * Environment variable set by the CDK CLI with the default AWS account ID.
 */
exports.DEFAULT_ACCOUNT_ENV = 'CDK_DEFAULT_ACCOUNT';
/**
 * Environment variable set by the CDK CLI with the default AWS region.
 */
exports.DEFAULT_REGION_ENV = 'CDK_DEFAULT_REGION';
/**
 * Version of Cloud Assembly expected by CDK CLI.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_ASM_VERSION_ENV = 'CDK_CLI_ASM_VERSION';
/**
 * Version of the CLI currently running.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_VERSION_ENV = 'CDK_CLI_VERSION';
/**
 * If a context value is an object with this key, it indicates an error
 */
exports.PROVIDER_ERROR_KEY = '$providerError';
/**
 * This SSM parameter does not invalidate the template
 *
 * If this string occurs in the description of an SSM parameter, the CLI
 * will not assume that the stack must always be redeployed.
 */
exports.SSMPARAM_NO_INVALIDATE = '[cdk:skip]';
//# sourceMappingURL=data:application/json;base64,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