"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NEW_PROJECT_DEFAULT_CONTEXT = exports.FUTURE_FLAGS = exports.FUTURE_FLAGS_EXPIRED = exports.futureFlagDefault = exports.CURRENT_VERSION_FLAG_DEFAULTS = exports.NEW_PROJECT_CONTEXT = exports.CURRENT_VERSION_EXPIRED_FLAGS = exports.FLAGS = exports.ENABLE_EMR_SERVICE_POLICY_V2 = exports.REDSHIFT_COLUMN_ID = exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = exports.ROUTE53_PATTERNS_USE_CERTIFICATE = exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = exports.ENABLE_PARTITION_LITERALS = exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = exports.S3_CREATE_DEFAULT_LOGGING_POLICY = exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = exports.IAM_MINIMIZE_POLICIES = exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = exports.TARGET_PARTITIONS = exports.CHECK_SECRET_USAGE = exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports.LAMBDA_RECOGNIZE_LAYER_VERSION = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
const flag_modeling_1 = require("./private/flag-modeling");
////////////////////////////////////////////////////////////////////////
//
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file.
//
////////////////////////////////////////////////////////////////////////
//
//  !!! IMPORTANT !!!
//
//  When you introduce a new flag, set its 'introducedIn.v2' value to the literal string
// 'V2·NEXT', without the dot.
//
//  DO NOT USE A VARIABLE. DO NOT DEFINE A CONSTANT. The actual value will be string-replaced at
//  version bump time.
//
////////////////////////////////////////////////////////////////////////
//
// There are three types of flags: ApiDefault, BugFix, and VisibleContext flags.
//
// - ApiDefault flags: change the behavior or defaults of the construct library. When
//   set, the infrastructure that is generated may be different but there is
//   a way to get the old infrastructure setup by using the API in a different way.
//
// - BugFix flags: the old infra we used to generate is no longer recommended,
//   and there is no way to achieve that result anymore except by making sure the
//   flag is unset, or set to `false`. Mostly used for infra-impacting bugfixes or
//   enhanced security defaults.
//
// - VisibleContext flags: not really a feature flag, but configurable context which is
//   advertised by putting the context in the `cdk.json` file of new projects.
//
// In future major versions, the "newProjectValues" will become the version
// default for both DefaultBehavior and BugFix flags, and DefaultBehavior flags
// will be removed (i.e., their new behavior will become the *only* behavior).
//
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
exports.DOCKER_IGNORE_SUPPORT = '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport';
exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = '@aws-cdk/aws-secretsmanager:parseOwnedSecretName';
exports.KMS_DEFAULT_KEY_POLICIES = '@aws-cdk/aws-kms:defaultKeyPolicies';
exports.S3_GRANT_WRITE_WITHOUT_ACL = '@aws-cdk/aws-s3:grantWriteWithoutAcl';
exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = '@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount';
exports.RDS_LOWERCASE_DB_IDENTIFIER = '@aws-cdk/aws-rds:lowercaseDbIdentifier';
exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = '@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId';
exports.EFS_DEFAULT_ENCRYPTION_AT_REST = '@aws-cdk/aws-efs:defaultEncryptionAtRest';
exports.LAMBDA_RECOGNIZE_VERSION_PROPS = '@aws-cdk/aws-lambda:recognizeVersionProps';
exports.LAMBDA_RECOGNIZE_LAYER_VERSION = '@aws-cdk/aws-lambda:recognizeLayerVersion';
exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = '@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021';
exports.CHECK_SECRET_USAGE = '@aws-cdk/core:checkSecretUsage';
exports.TARGET_PARTITIONS = '@aws-cdk/core:target-partitions';
exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = '@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver';
exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = '@aws-cdk/aws-ec2:uniqueImdsv2TemplateName';
exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = '@aws-cdk/aws-ecs:arnFormatIncludesClusterName';
exports.IAM_MINIMIZE_POLICIES = '@aws-cdk/aws-iam:minimizePolicies';
exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = '@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName';
exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = '@aws-cdk/core:validateSnapshotRemovalPolicy';
exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = '@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName';
exports.S3_CREATE_DEFAULT_LOGGING_POLICY = '@aws-cdk/aws-s3:createDefaultLoggingPolicy';
exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = '@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption';
exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = '@aws-cdk/aws-apigateway:disableCloudWatchRole';
exports.ENABLE_PARTITION_LITERALS = '@aws-cdk/core:enablePartitionLiterals';
exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = '@aws-cdk/aws-events:eventsTargetQueueSameAccount';
exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = '@aws-cdk/aws-iam:standardizedServicePrincipals';
exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = '@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker';
exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = '@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy';
exports.ROUTE53_PATTERNS_USE_CERTIFICATE = '@aws-cdk/aws-route53-patters:useCertificate';
exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = '@aws-cdk/customresources:installLatestAwsSdkDefault';
exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = '@aws-cdk/aws-rds:databaseProxyUniqueResourceName';
exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = '@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup';
exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = '@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId';
exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = '@aws-cdk/aws-ec2:launchTemplateDefaultUserData';
exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = '@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments';
exports.REDSHIFT_COLUMN_ID = '@aws-cdk/aws-redshift:columnId';
exports.ENABLE_EMR_SERVICE_POLICY_V2 = '@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2';
exports.FLAGS = {
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Allow multiple stacks with the same name',
        detailsMd: `
      If this is set, multiple stacks can use the same stack name (e.g. deployed to
      different environments). This means that the name of the synthesized template
      file will be based on the construct path and not on the defined \`stackName\`
      of the stack.`,
        recommendedValue: true,
        introducedIn: { v1: '1.16.0' },
        defaults: { v2: true },
        compatibilityWithOldBehaviorMd: 'Pass stack identifiers to the CLI instead of stack names.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Make `cdk diff` not fail when there are differences',
        detailsMd: `
      Determines what status code \`cdk diff\` should return when the specified stack
      differs from the deployed stack or the local CloudFormation template:

      * \`aws-cdk:enableDiffNoFail=true\` => status code == 0
      * \`aws-cdk:enableDiffNoFail=false\` => status code == 1

      You can override this behavior with the --fail flag:

      * \`--fail\` => status code == 1
      * \`--no-fail\` => status code == 0`,
        introducedIn: { v1: '1.19.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify `--fail` to the CLI.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Switch to new stack synthesis method which enables CI/CD',
        detailsMd: `
      If this flag is specified, all \`Stack\`s will use the \`DefaultStackSynthesizer\` by
      default. If it is not set, they will use the \`LegacyStackSynthesizer\`.`,
        introducedIn: { v1: '1.39.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Name exports based on the construct paths relative to the stack, rather than the global construct path',
        detailsMd: `
      Combined with the stack name this relative construct path is good enough to
      ensure uniqueness, and makes the export names robust against refactoring
      the location of the stack in the construct tree (specifically, moving the Stack
      into a Stage).`,
        introducedIn: { v1: '1.58.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DOCKER_IGNORE_SUPPORT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'DockerImageAsset properly supports `.dockerignore` files by default',
        detailsMd: `
      If this flag is not set, the default behavior for \`DockerImageAsset\` is to use
      glob semantics for \`.dockerignore\` files. If this flag is set, the default behavior
      is standard Docker ignore semantics.

      This is a feature flag as the old behavior was technically incorrect but
      users may have come to depend on it.`,
        introducedIn: { v1: '1.73.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Update your `.dockerignore` file to match standard Docker ignore rules, if necessary.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Fix the referencing of SecretsManager names from ARNs',
        detailsMd: `
      Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
      rather than the default full resource name, which includes the SecretsManager suffix.

      If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
      used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).`,
        introducedIn: { v1: '1.77.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Use `parseArn(secret.secretName).resourceName` to emulate the incorrect old parsing.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_DEFAULT_KEY_POLICIES]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Tighten default KMS key policies',
        detailsMd: `
      KMS Keys start with a default key policy that grants the account access to administer the key,
      mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
      policy by specifying their own.

      If this flag is not set, the default key policy depends on the setting of the \`trustAccountIdentities\`
      flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
      resembles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
      true, the policy matches what happens when this feature flag is set.

      Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
      to the key's default policy (rather than replacing it).`,
        introducedIn: { v1: '1.78.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `trustAccountIdentities: false` to `Key` construct to restore the old behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_GRANT_WRITE_WITHOUT_ACL]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Remove `PutObjectAcl` from Bucket.grantWrite',
        detailsMd: `
      Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
      as the former includes 's3:PutObjectAcl',
      which could be used to grant read/write object access to IAM principals in other accounts.
      Use a feature flag to make sure existing customers who might be relying
      on the overly-broad permissions are not broken.`,
        introducedIn: { v1: '1.85.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Call `bucket.grantPutAcl()` in addition to `bucket.grantWrite()` to grant ACL permissions.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Do not specify a default DesiredCount for ECS services',
        detailsMd: `
      ApplicationLoadBalancedServiceBase, ApplicationMultipleTargetGroupServiceBase,
      NetworkLoadBalancedServiceBase, NetworkMultipleTargetGroupServiceBase, and
      QueueProcessingServiceBase currently determine a default value for the desired count of
      a CfnService if a desiredCount is not provided. The result of this is that on every
      deployment, the service count is reset to the fixed value, even if it was autoscaled.

      If this flag is not set, the default behaviour for CfnService.desiredCount is to set a
      desiredCount of 1, if one is not provided. If true, a default will not be defined for
      CfnService.desiredCount and as such desiredCount will be undefined, if one is not provided.`,
        introducedIn: { v1: '1.92.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'You can pass `desiredCount: 1` explicitly, but you should never need this.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.RDS_LOWERCASE_DB_IDENTIFIER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Force lowercasing of RDS Cluster names in CDK',
        detailsMd: `
      Cluster names must be lowercase, and the service will lowercase the name when the cluster
      is created. However, CDK did not use to know about this, and would use the user-provided name
      referencing the cluster, which would fail if it happened to be mixed-case.

      With this flag, lowercase the name in CDK so we can reference it properly.

      Must be behind a permanent flag because changing a name from mixed case to lowercase between deployments
      would lead CloudFormation to think the name was changed and would trigger a cluster replacement
      (losing data!).`,
        introducedIn: { v1: '1.97.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Allow adding/removing multiple UsagePlanKeys independently',
        detailsMd: `
      The UsagePlanKey resource connects an ApiKey with a UsagePlan. API Gateway does not allow more than one UsagePlanKey
      for any given UsagePlan and ApiKey combination. For this reason, CloudFormation cannot replace this resource without
      either the UsagePlan or ApiKey changing.

      The feature addition to support multiple UsagePlanKey resources - 142bd0e2 - recognized this and attempted to keep
      existing UsagePlanKey logical ids unchanged.
      However, this intentionally caused the logical id of the UsagePlanKey to be sensitive to order. That is, when
      the 'first' UsagePlanKey resource is removed, the logical id of the 'second' assumes what was originally the 'first',
      which again is disallowed.

      In effect, there is no way to get out of this mess in a backwards compatible way, while supporting existing stacks.
      This flag changes the logical id layout of UsagePlanKey to not be sensitive to order.`,
        introducedIn: { v1: '1.98.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enable this feature flag to have elastic file systems encrypted at rest by default.',
        detailsMd: `
      Encryption can also be configured explicitly using the \`encrypted\` property.
      `,
        introducedIn: { v1: '1.98.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass the `encrypted: false` property to the `FileSystem` construct to disable encryption.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the  `fn.currentVersion`.',
        detailsMd: `
      The previous calculation incorrectly considered properties of the \`AWS::Lambda::Function\` resource that did
      not constitute creating a new Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.106.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_LAYER_VERSION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the `fn.currentVersion`.',
        detailsMd: `
      This flag correct incorporates Lambda Layer properties into the Lambda Function Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.159.0', v2: '2.27.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have cloudfront distributions use the security policy TLSv1.2_2021 by default.',
        detailsMd: `
      The security policy can also be configured explicitly using the \`minimumProtocolVersion\` property.`,
        introducedIn: { v1: '1.117.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CHECK_SECRET_USAGE]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Enable this flag to make it impossible to accidentally use SecretValues in unsafe locations',
        detailsMd: `
      With this flag enabled, \`SecretValue\` instances can only be passed to
      constructs that accept \`SecretValue\`s; otherwise, \`unsafeUnwrap()\` must be
      called to use it as a regular string.`,
        introducedIn: { v1: '1.153.0', v2: '2.21.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.TARGET_PARTITIONS]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'What regions to include in lookup tables of environment agnostic stacks',
        detailsMd: `
      Has no effect on stacks that have a defined region, but will limit the amount
      of unnecessary regions included in stacks without a known region.

      The type of this value should be a list of strings.`,
        introducedIn: { v1: '1.137.0', v2: '2.4.0' },
        recommendedValue: ['aws', 'aws-cn'],
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'ECS extensions will automatically add an `awslogs` driver if no logging is specified',
        detailsMd: `
      Enable this feature flag to configure default logging behavior for the ECS Service Extensions. This will enable the
      \`awslogs\` log driver for the application container of the service to send the container logs to CloudWatch Logs.

      This is a feature flag as the new behavior provides a better default experience for the users.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify a log driver explicitly.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have Launch Templates generated by the `InstanceRequireImdsv2Aspect` use unique names.',
        detailsMd: `
      Previously, the generated Launch Template names were only unique within a stack because they were based only on the
      \`Instance\` construct ID. If another stack that has an \`Instance\` with the same construct ID is deployed in the same
      account and region, the deployments would always fail as the generated Launch Template names were the same.

      The new implementation addresses this issue by generating the Launch Template name with the \`Names.uniqueId\` method.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'ARN format used by ECS. In the new ARN format, the cluster name is part of the resource ID.',
        detailsMd: `
      If this flag is not set, the old ARN format (without cluster name) for ECS is used.
      If this flag is set, the new ARN format (with cluster name) for ECS is used.

      This is a feature flag as the old format is still valid for existing ECS clusters.

      See https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids
      `,
        introducedIn: { v2: '2.35.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_MINIMIZE_POLICIES]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Minimize IAM policies by combining Statements',
        detailsMd: `
      Minimize IAM policies by combining Principals, Actions and Resources of two
      Statements in the policies, as long as it doesn't change the meaning of the
      policy.`,
        introducedIn: { v1: '1.150.0', v2: '2.18.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Error on snapshot removal policies on resources that do not support it.',
        detailsMd: `
      Makes sure we do not allow snapshot removal policy on resources that do not support it.
      If supplied on an unsupported resource, CloudFormation ignores the policy altogether.
      This flag will reduce confusion and unexpected loss of data when erroneously supplying
      the snapshot removal policy.`,
        introducedIn: { v2: '2.28.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'The old behavior was incorrect. Update your source to not specify SNAPSHOT policies on resources that do not support it.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate key aliases that include the stack name',
        detailsMd: `
      Enable this feature flag to have CodePipeline generate a unique cross account key alias name using the stack name.

      Previously, when creating multiple pipelines with similar naming conventions and when crossAccountKeys is true,
      the KMS key alias name created for these pipelines may be the same due to how the uniqueId is generated.

      This new implementation creates a stack safe resource name for the alias using the stack name instead of the stack ID.
      `,
        introducedIn: { v2: '2.29.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_CREATE_DEFAULT_LOGGING_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to create an S3 bucket policy by default in cases where an AWS service would automatically create the Policy if one does not exist.',
        detailsMd: `
      For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
      that needs to be attached to the bucket. If you create the bucket without a policy and then add the
      bucket as the flow log destination, the service will automatically create the bucket policy with the
      necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
      and error indicating that a bucket policy already exists.

      In cases where we know what the required policy is we can go ahead and create the policy so we can
      remain in control of it.

      @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
      `,
        introducedIn: { v2: '2.31.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Restrict KMS key policy for encrypted Queues a bit more',
        detailsMd: `
      Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
      only the topic which it is subscribed to and not the whole SNS service of an account.

      Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
      secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
      the subscribed queue.`,
        introducedIn: { v2: '2.32.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make default CloudWatch Role behavior safe for multiple API Gateways in one environment',
        detailsMd: `
      Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
      to _not_ create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
      environment which means that each time you create a RestApi in your account the ApiGateway account
      is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
      role will also be deleted, breaking any existing ApiGateways that were depending on them.

      When this flag is enabled you should either create the ApiGateway account and CloudWatch role
      separately _or_ only enable the cloudWatchRole on a single RestApi.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_PARTITION_LITERALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make ARNs concrete if AWS partition is known',
        detailsMd: `
      Enable this feature flag to get partition names as string literals in Stacks with known regions defined in
      their environment, such as "aws" or "aws-cn".  Previously the CloudFormation intrinsic function
      "Ref: AWS::Partition" was used.  For example:

      \`\`\`yaml
      Principal:
        AWS:
          Fn::Join:
            - ""
            - - "arn:"
              - Ref: AWS::Partition
              - :iam::123456789876:root
      \`\`\`

      becomes:

      \`\`\`yaml
      Principal:
        AWS: "arn:aws:iam::123456789876:root"
      \`\`\`

      The intrinsic function will still be used in Stacks where no region is defined or the region's partition
      is unknown.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Event Rules may only push to encrypted SQS queues in the same account',
        detailsMd: `
      This flag applies to SQS Queues that are used as the target of event Rules. When enabled, only principals
      from the same account as the Rule can send messages. If a queue is unencrypted, this restriction will
      always apply, regardless of the value of this flag.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use standardized (global) service principals everywhere',
        detailsMd: `
      We used to maintain a database of exceptions to Service Principal names in various regions. This database
      is no longer necessary: all service principals names have been standardized to their global form (\`SERVICE.amazonaws.com\`).

      This flag disables use of that exceptions database and always uses the global service principal.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Avoid setting the "ECS" deployment controller when adding a circuit breaker',
        detailsMd: `
      Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
      ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
      This does not change any behaviour as the default deployment controller when it is not defined is ECS.

      This is a feature flag as the new behavior provides a better default experience for the users.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature to by default create default policy names for imported roles that depend on the stack the role is in.',
        detailsMd: `
      Without this, importing the same role in multiple places could lead to the permissions given for one version of the imported role
      to overwrite permissions given to the role at a different place where it was imported. This was due to all imported instances
      of a role using the same default policy name.

      This new implementation creates default policy names based on the constructs node path in their stack.
      `,
        introducedIn: { v2: '2.60.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use S3 Bucket Policy instead of ACLs for Server Access Logging',
        detailsMd: `
      Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
      rather than using the canned \`LogDeliveryWrite\` ACL. ACLs do not work when Object Ownership is
      enabled on the bucket.

      This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
      practices for S3.

      @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html
    `,
        introducedIn: { v2: '2.59.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ROUTE53_PATTERNS_USE_CERTIFICATE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Use the official `Certificate` resource instead of `DnsValidatedCertificate`',
        detailsMd: `
      Enable this feature flag to use the official CloudFormation supported \`Certificate\` resource instead
      of the deprecated \`DnsValidatedCertificate\` construct. If this flag is enabled and you are creating
      the stack in a region other than us-east-1 then you must also set \`crossRegionReferences=true\` on the
      stack.
      `,
        introducedIn: { v2: 'V2·NEXT' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Define a `DnsValidatedCertificate` explicitly and pass in the `certificate` property',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Whether to install the latest SDK by default in AwsCustomResource',
        detailsMd: `
      This was originally introduced and enabled by default to not be limited by the SDK version
      that's installed on AWS Lambda. However, it creates issues for Lambdas bound to VPCs that
      do not have internet access, or in environments where 'npmjs.com' is not available.

      The recommended setting is to disable the default installation behavior, and pass the
      flag on a resource-by-resource basis to enable it if necessary.
    `,
        compatibilityWithOldBehaviorMd: 'Set installLatestAwsSdk: true on all resources that need it.',
        introducedIn: { v2: '2.60.0' },
        recommendedValue: false,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use unique resource name for Database Proxy',
        detailsMd: `
      If this flag is not set, the default behavior for \`DatabaseProxy\` is
      to use \`id\` of the constructor for \`dbProxyName\` when it's not specified in the argument.
      In this case, users can't deploy \`DatabaseProxy\`s that have the same \`id\` in the same region.

      If this flag is set, the default behavior is to use unique resource names for each \`DatabaseProxy\`.

      This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Remove CloudWatch alarms from deployment group',
        detailsMd: `
      Enable this flag to be able to remove all CloudWatch alarms from a deployment group by removing
      the alarms from the construct. If this flag is not set, removing all alarms from the construct
      will still leave the alarms configured for the deployment group.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Include authorizer configuration in the calculation of the API deployment logical ID.',
        detailsMd: `
      The logical ID of the AWS::ApiGateway::Deployment resource is calculated by hashing
      the API configuration, including methods, and resources, etc. Enable this feature flag
      to also include the configuration of any authorizer attached to the API in the
      calculation, so any changes made to an authorizer will create a new deployment.
      `,
        introducedIn: { v2: '2.66.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Define user data for a launch template by default when a machine image is provided.',
        detailsMd: `
      The ec2.LaunchTemplate construct did not define user data when a machine image is
      provided despite the document. If this is set, a user data is automatically defined
      according to the OS of the machine image.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'SecretTargetAttachments uses the ResourcePolicy of the attached Secret.',
        detailsMd: `
      Enable this feature flag to make SecretTargetAttachments use the ResourcePolicy of the attached Secret.
      SecretTargetAttachments are created to connect a Secret to a target resource. 
      In CDK code, they behave like regular Secret and can be used as a stand-in in most situations.
      Previously, adding to the ResourcePolicy of a SecretTargetAttachment did attempt to create a separate ResourcePolicy for the same Secret.
      However Secrets can only have a single ResourcePolicy, causing the CloudFormation deployment to fail.

      When enabling this feature flag for an existing Stack, ResourcePolicies created via a SecretTargetAttachment will need replacement.
      This won't be possible without intervention due to limitation outlined above.
      First remove all permissions granted to the Secret and deploy without the ResourcePolicies.
      Then you can re-add the permissions and deploy again.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.REDSHIFT_COLUMN_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Whether to use an ID to track Redshift column changes',
        detailsMd: `
      Redshift columns are identified by their \`name\`. If a column is renamed, the old column
      will be dropped and a new column will be created. This can cause data loss.

      This flag enables the use of an \`id\` attribute for Redshift columns. If this flag is enabled, the
      internal CDK architecture will track changes of Redshift columns through their \`id\`, rather
      than their \`name\`. This will prevent data loss when columns are renamed.

      **NOTE** - Enabling this flag comes at a **risk**. When enabled, update the \`id\`s of all columns,
      **however** do not change the \`names\`s of the columns. If the \`name\`s of the columns are changed during
      initial deployment, the columns will be dropped and recreated, causing data loss. After the initial deployment
      of the \`id\`s, the \`name\`s of the columns can be changed without data loss.
      `,
        introducedIn: { v2: '2.68.0' },
        recommendedValue: true,
    },
    [exports.ENABLE_EMR_SERVICE_POLICY_V2]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable AmazonEMRServicePolicy_v2 managed policies',
        detailsMd: `
      If this flag is not set, the default behavior for \`EmrCreateCluster\` is
      to use \`AmazonElasticMapReduceRole\` managed policies.

      If this flag is set, the default behavior is to use the new \`AmazonEMRServicePolicy_v2\`
      managed policies.

      This is a feature flag as the old behavior will be deprecated, but some resources may require manual
      intervention since they might not have the appropriate tags propagated automatically.
      `,
        introducedIn: { v2: '2.72.0' },
        recommendedValue: true,
    },
};
const CURRENT_MV = 'v2';
/**
 * The list of future flags that are now expired. This is going to be used to identify
 * and block usages of old feature flags in the new major version of CDK.
 */
exports.CURRENT_VERSION_EXPIRED_FLAGS = Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.introducedIn[CURRENT_MV] === undefined)
    .map(([name, _]) => name).sort();
/**
 * Flag values that should apply for new projects
 *
 * Add a flag in here (typically with the value `true`), to enable
 * backwards-breaking behavior changes only for new projects.  New projects
 * generated through `cdk init` will include these flags in their generated
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.NEW_PROJECT_CONTEXT = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.recommendedValue !== flag.defaults?.[CURRENT_MV] && flag.introducedIn[CURRENT_MV])
    .map(([name, flag]) => [name, flag.recommendedValue]));
/**
 * The default values of each of these flags in the current major version.
 *
 * This is the effective value of the flag, unless it's overriden via
 * context.
 *
 * Adding new flags here is only allowed during the pre-release period of a new
 * major version!
 */
exports.CURRENT_VERSION_FLAG_DEFAULTS = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.defaults?.[CURRENT_MV] !== undefined)
    .map(([name, flag]) => [name, flag.defaults?.[CURRENT_MV]]));
function futureFlagDefault(flag) {
    const value = exports.CURRENT_VERSION_FLAG_DEFAULTS[flag] ?? false;
    if (typeof value !== 'boolean') {
        throw new Error(`futureFlagDefault: default type of flag '${flag}' should be boolean, got '${typeof value}'`);
    }
    return value;
}
exports.futureFlagDefault = futureFlagDefault;
// Nobody should have been using any of this, but you never know
/** @deprecated use CURRENT_VERSION_EXPIRED_FLAGS instead */
exports.FUTURE_FLAGS_EXPIRED = exports.CURRENT_VERSION_EXPIRED_FLAGS;
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.FUTURE_FLAGS = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v === 'boolean'));
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.NEW_PROJECT_DEFAULT_CONTEXT = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v !== 'boolean'));
//# sourceMappingURL=data:application/json;base64,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