"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCliLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const asset_awscli_v1_1 = require("@aws-cdk/asset-awscli-v1");
const lambda = require("../../aws-lambda");
const core_1 = require("../../core");
/**
 * An AWS Lambda layer that includes the AWS CLI.
 */
class AwsCliLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(asset_awscli_v1_1.ASSET_FILE, {
                // we hash the layer directory (it contains the tools versions and Dockerfile) because hashing the zip is non-deterministic
                assetHash: core_1.FileSystem.fingerprint(asset_awscli_v1_1.LAYER_SOURCE_DIR),
            }),
            description: '/opt/awscli/aws',
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
AwsCliLayer[_a] = { fqn: "aws-cdk-lib.lambda_layer_awscli.AwsCliLayer", version: "2.74.0" };
exports.AwsCliLayer = AwsCliLayer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2xpLWxheWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzY2xpLWxheWVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOERBQXdFO0FBQ3hFLDJDQUEyQztBQUMzQyxxQ0FBd0M7QUFHeEM7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxNQUFNLENBQUMsWUFBWTtJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyw0QkFBVSxFQUFFO2dCQUN0QywySEFBMkg7Z0JBQzNILFNBQVMsRUFBRSxpQkFBVSxDQUFDLFdBQVcsQ0FBQyxrQ0FBZ0IsQ0FBQzthQUNwRCxDQUFDO1lBQ0YsV0FBVyxFQUFFLGlCQUFpQjtTQUMvQixDQUFDLENBQUM7S0FDSjs7OztBQVRVLGtDQUFXIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQVNTRVRfRklMRSwgTEFZRVJfU09VUkNFX0RJUiB9IGZyb20gJ0Bhd3MtY2RrL2Fzc2V0LWF3c2NsaS12MSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnLi4vLi4vYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBGaWxlU3lzdGVtIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBBbiBBV1MgTGFtYmRhIGxheWVyIHRoYXQgaW5jbHVkZXMgdGhlIEFXUyBDTEkuXG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NDbGlMYXllciBleHRlbmRzIGxhbWJkYS5MYXllclZlcnNpb24ge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQoQVNTRVRfRklMRSwge1xuICAgICAgICAvLyB3ZSBoYXNoIHRoZSBsYXllciBkaXJlY3RvcnkgKGl0IGNvbnRhaW5zIHRoZSB0b29scyB2ZXJzaW9ucyBhbmQgRG9ja2VyZmlsZSkgYmVjYXVzZSBoYXNoaW5nIHRoZSB6aXAgaXMgbm9uLWRldGVybWluaXN0aWNcbiAgICAgICAgYXNzZXRIYXNoOiBGaWxlU3lzdGVtLmZpbmdlcnByaW50KExBWUVSX1NPVVJDRV9ESVIpLFxuICAgICAgfSksXG4gICAgICBkZXNjcmlwdGlvbjogJy9vcHQvYXdzY2xpL2F3cycsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==