"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const asset_kubectl_v20_1 = require("@aws-cdk/asset-kubectl-v20");
const lambda = require("../../aws-lambda");
const core_1 = require("../../core");
/**
 * An AWS Lambda layer that includes `kubectl` and `helm`.
 */
class KubectlLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(asset_kubectl_v20_1.ASSET_FILE, {
                // we hash the layer directory (it contains the tools versions and Dockerfile) because hashing the zip is non-deterministic
                assetHash: core_1.FileSystem.fingerprint(asset_kubectl_v20_1.LAYER_SOURCE_DIR),
            }),
            description: '/opt/kubectl/kubectl and /opt/helm/helm',
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
KubectlLayer[_a] = { fqn: "aws-cdk-lib.lambda_layer_kubectl.KubectlLayer", version: "2.74.0" };
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia3ViZWN0bC1sYXllci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImt1YmVjdGwtbGF5ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxrRUFBMEU7QUFDMUUsMkNBQTJDO0FBQzNDLHFDQUF3QztBQUd4Qzs7R0FFRztBQUNILE1BQWEsWUFBYSxTQUFRLE1BQU0sQ0FBQyxZQUFZO0lBQ25ELFlBQVksS0FBZ0IsRUFBRSxFQUFVO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLDhCQUFVLEVBQUU7Z0JBQ3RDLDJIQUEySDtnQkFDM0gsU0FBUyxFQUFFLGlCQUFVLENBQUMsV0FBVyxDQUFDLG9DQUFnQixDQUFDO2FBQ3BELENBQUM7WUFDRixXQUFXLEVBQUUseUNBQXlDO1NBQ3ZELENBQUMsQ0FBQztLQUNKOzs7O0FBVFUsb0NBQVkiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBU1NFVF9GSUxFLCBMQVlFUl9TT1VSQ0VfRElSIH0gZnJvbSAnQGF3cy1jZGsvYXNzZXQta3ViZWN0bC12MjAnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJy4uLy4uL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbSB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogQW4gQVdTIExhbWJkYSBsYXllciB0aGF0IGluY2x1ZGVzIGBrdWJlY3RsYCBhbmQgYGhlbG1gLlxuICovXG5leHBvcnQgY2xhc3MgS3ViZWN0bExheWVyIGV4dGVuZHMgbGFtYmRhLkxheWVyVmVyc2lvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChBU1NFVF9GSUxFLCB7XG4gICAgICAgIC8vIHdlIGhhc2ggdGhlIGxheWVyIGRpcmVjdG9yeSAoaXQgY29udGFpbnMgdGhlIHRvb2xzIHZlcnNpb25zIGFuZCBEb2NrZXJmaWxlKSBiZWNhdXNlIGhhc2hpbmcgdGhlIHppcCBpcyBub24tZGV0ZXJtaW5pc3RpY1xuICAgICAgICBhc3NldEhhc2g6IEZpbGVTeXN0ZW0uZmluZ2VycHJpbnQoTEFZRVJfU09VUkNFX0RJUiksXG4gICAgICB9KSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnL29wdC9rdWJlY3RsL2t1YmVjdGwgYW5kIC9vcHQvaGVsbS9oZWxtJyxcbiAgICB9KTtcbiAgfVxufVxuIl19