"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSet = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A set of files traveling through the deployment pipeline
 *
 * Individual steps in the pipeline produce or consume
 * `FileSet`s.
 */
class FileSet {
    constructor(
    /** Human-readable descriptor for this file set (does not need to be unique) */
    id, producer) {
        this.id = id;
        /**
         * The primary output of a file set producer
         *
         * The primary output of a FileSet is itself.
         */
        this.primaryOutput = this;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_Step(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FileSet);
            }
            throw error;
        }
        this._producer = producer;
    }
    /**
     * The Step that produces this FileSet
     */
    get producer() {
        if (!this._producer) {
            throw new Error(`FileSet '${this.id}' doesn\'t have a producer; call 'fileSet.producedBy()'`);
        }
        return this._producer;
    }
    /**
     * Mark the given Step as the producer for this FileSet
     *
     * This method can only be called once.
     */
    producedBy(producer) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_Step(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.producedBy);
            }
            throw error;
        }
        if (this._producer) {
            throw new Error(`FileSet '${this.id}' already has a producer (${this._producer}) while setting producer: ${producer}`);
        }
        this._producer = producer;
    }
    /**
     * Return a string representation of this FileSet
     */
    toString() {
        return `FileSet(${this.id})`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
FileSet[_a] = { fqn: "aws-cdk-lib.pipelines.FileSet", version: "2.74.0" };
exports.FileSet = FileSet;
//# sourceMappingURL=data:application/json;base64,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