"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wave = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stage_deployment_1 = require("./stage-deployment");
/**
 * Multiple stages that are deployed in parallel
 */
class Wave {
    constructor(
    /** Identifier for this Wave */
    id, props = {}) {
        this.id = id;
        /**
         * The stages that are deployed in this wave
         */
        this.stages = [];
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_WaveProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Wave);
            }
            throw error;
        }
        this.pre = props.pre ?? [];
        this.post = props.post ?? [];
    }
    /**
     * Add a Stage to this wave
     *
     * It will be deployed in parallel with all other stages in this
     * wave.
     */
    addStage(stage, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_Stage(stage);
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_AddStageOpts(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        const ret = stage_deployment_1.StageDeployment.fromStage(stage, options);
        this.stages.push(ret);
        return ret;
    }
    /**
     * Add an additional step to run before any of the stages in this wave
     */
    addPre(...steps) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_Step(steps);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPre);
            }
            throw error;
        }
        this.pre.push(...steps);
    }
    /**
     * Add an additional step to run after all of the stages in this wave
     */
    addPost(...steps) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_Step(steps);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPost);
            }
            throw error;
        }
        this.post.push(...steps);
    }
}
_a = JSII_RTTI_SYMBOL_1;
Wave[_a] = { fqn: "aws-cdk-lib.pipelines.Wave", version: "2.74.0" };
exports.Wave = Wave;
//# sourceMappingURL=data:application/json;base64,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