"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfirmPermissionsBroadening = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cpa = require("../../../aws-codepipeline-actions");
const constructs_1 = require("constructs");
const blueprint_1 = require("../blueprint");
const application_security_check_1 = require("../private/application-security-check");
/**
 * Pause the pipeline if a deployment would add IAM permissions or Security Group rules
 *
 * This step is only supported in CodePipeline pipelines.
 */
class ConfirmPermissionsBroadening extends blueprint_1.Step {
    constructor(id, props) {
        super(id);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_PermissionsBroadeningCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ConfirmPermissionsBroadening);
            }
            throw error;
        }
    }
    produceAction(stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_ProduceActionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.produceAction);
            }
            throw error;
        }
        const sec = this.getOrCreateSecCheck(options.pipeline);
        this.props.notificationTopic?.grantPublish(sec.cdkDiffProject);
        const variablesNamespace = constructs_1.Node.of(this.props.stage).addr;
        const approveActionName = `${options.actionName}.Confirm`;
        stage.addAction(new cpa.CodeBuildAction({
            runOrder: options.runOrder,
            actionName: `${options.actionName}.Check`,
            input: options.artifacts.toCodePipeline(options.pipeline.cloudAssemblyFileSet),
            project: sec.cdkDiffProject,
            variablesNamespace,
            environmentVariables: {
                STAGE_PATH: { value: constructs_1.Node.of(this.props.stage).path },
                STAGE_NAME: { value: stage.stageName },
                ACTION_NAME: { value: approveActionName },
                ...this.props.notificationTopic ? {
                    NOTIFICATION_ARN: { value: this.props.notificationTopic.topicArn },
                    NOTIFICATION_SUBJECT: { value: `Confirm permission broadening in ${this.props.stage.stageName}` },
                } : {},
            },
        }));
        stage.addAction(new cpa.ManualApprovalAction({
            actionName: approveActionName,
            runOrder: options.runOrder + 1,
            additionalInformation: `#{${variablesNamespace}.MESSAGE}`,
            externalEntityLink: `#{${variablesNamespace}.LINK}`,
        }));
        return { runOrdersConsumed: 2 };
    }
    getOrCreateSecCheck(pipeline) {
        const id = 'PipelinesSecurityCheck';
        const existing = constructs_1.Node.of(pipeline).tryFindChild(id);
        if (existing) {
            if (!(existing instanceof application_security_check_1.ApplicationSecurityCheck)) {
                throw new Error(`Expected '${constructs_1.Node.of(existing).path}' to be 'ApplicationSecurityCheck' but was '${existing}'`);
            }
            return existing;
        }
        return new application_security_check_1.ApplicationSecurityCheck(pipeline, id, {
            codePipeline: pipeline.pipeline,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
ConfirmPermissionsBroadening[_a] = { fqn: "aws-cdk-lib.pipelines.ConfirmPermissionsBroadening", version: "2.74.0" };
exports.ConfirmPermissionsBroadening = ConfirmPermissionsBroadening;
//# sourceMappingURL=data:application/json;base64,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