"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutputsMap = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const pipeline_queries_1 = require("../helpers-internal/pipeline-queries");
const identifiers_1 = require("../private/identifiers");
/**
 * Translate stack outputs to Codepipline variable references
 */
class StackOutputsMap {
    constructor(pipeline) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_PipelineBase(pipeline);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StackOutputsMap);
            }
            throw error;
        }
        this.queries = new pipeline_queries_1.PipelineQueries(pipeline);
    }
    /**
     * Return the matching variable reference string for a StackOutputReference
     */
    toCodePipeline(x) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_StackOutputReference(x);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.toCodePipeline);
            }
            throw error;
        }
        return `#{${(0, identifiers_1.stackVariableNamespace)(this.queries.producingStack(x))}.${x.outputName}}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
StackOutputsMap[_a] = { fqn: "aws-cdk-lib.pipelines.StackOutputsMap", version: "2.74.0" };
exports.StackOutputsMap = StackOutputsMap;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stb3V0cHV0cy1tYXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay1vdXRwdXRzLW1hcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwyRUFBdUU7QUFFdkUsd0RBQWdFO0FBRWhFOztHQUVHO0FBQ0gsTUFBYSxlQUFlO0lBRzFCLFlBQVksUUFBc0I7Ozs7OzsrQ0FIdkIsZUFBZTs7OztRQUl4QixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksa0NBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUM5QztJQUVEOztPQUVHO0lBQ0ksY0FBYyxDQUFDLENBQXVCOzs7Ozs7Ozs7O1FBQzNDLE9BQU8sS0FBSyxJQUFBLG9DQUFzQixFQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsR0FBRyxDQUFDO0tBQ3ZGOzs7O0FBWlUsMENBQWUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGFja091dHB1dFJlZmVyZW5jZSB9IGZyb20gJy4uL2JsdWVwcmludCc7XG5pbXBvcnQgeyBQaXBlbGluZVF1ZXJpZXMgfSBmcm9tICcuLi9oZWxwZXJzLWludGVybmFsL3BpcGVsaW5lLXF1ZXJpZXMnO1xuaW1wb3J0IHsgUGlwZWxpbmVCYXNlIH0gZnJvbSAnLi4vbWFpbic7XG5pbXBvcnQgeyBzdGFja1ZhcmlhYmxlTmFtZXNwYWNlIH0gZnJvbSAnLi4vcHJpdmF0ZS9pZGVudGlmaWVycyc7XG5cbi8qKlxuICogVHJhbnNsYXRlIHN0YWNrIG91dHB1dHMgdG8gQ29kZXBpcGxpbmUgdmFyaWFibGUgcmVmZXJlbmNlc1xuICovXG5leHBvcnQgY2xhc3MgU3RhY2tPdXRwdXRzTWFwIHtcbiAgcHJpdmF0ZSBxdWVyaWVzOiBQaXBlbGluZVF1ZXJpZXNcblxuICBjb25zdHJ1Y3RvcihwaXBlbGluZTogUGlwZWxpbmVCYXNlKSB7XG4gICAgdGhpcy5xdWVyaWVzID0gbmV3IFBpcGVsaW5lUXVlcmllcyhwaXBlbGluZSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIHRoZSBtYXRjaGluZyB2YXJpYWJsZSByZWZlcmVuY2Ugc3RyaW5nIGZvciBhIFN0YWNrT3V0cHV0UmVmZXJlbmNlXG4gICAqL1xuICBwdWJsaWMgdG9Db2RlUGlwZWxpbmUoeDogU3RhY2tPdXRwdXRSZWZlcmVuY2UpOiBzdHJpbmcge1xuICAgIHJldHVybiBgI3ske3N0YWNrVmFyaWFibGVOYW1lc3BhY2UodGhpcy5xdWVyaWVzLnByb2R1Y2luZ1N0YWNrKHgpKX0uJHt4Lm91dHB1dE5hbWV9fWA7XG4gIH1cbn0iXX0=