"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublishAssetsAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const codebuild = require("../../../../aws-codebuild");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
const core_1 = require("../../../../core");
const constructs_1 = require("constructs");
const asset_type_1 = require("../../blueprint/asset-type");
const default_codebuild_image_1 = require("../../private/default-codebuild-image");
const fs_1 = require("../../private/fs");
/**
 * Action to publish an asset in the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class PublishAssetsAction extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.commands = new Array();
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const installCommand = `npm install -g cdk-assets${installSuffix}`;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: props.preInstallCommands ? [...props.preInstallCommands, installCommand] : installCommand,
                },
                build: {
                    commands: core_1.Lazy.list({ produce: () => this.commands }),
                },
            },
        });
        this.buildSpec = props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec;
        const project = new codebuild.PipelineProject(this, 'Default', {
            projectName: this.props.projectName,
            environment: {
                buildImage: default_codebuild_image_1.CDKP_DEFAULT_CODEBUILD_IMAGE,
                privileged: (props.assetType === asset_type_1.AssetType.DOCKER_IMAGE) ? true : undefined,
            },
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            buildSpec: props.createBuildspecFile ? codebuild.BuildSpec.fromSourceFilename(this.getBuildSpecFileName()) : this.buildSpec,
            role: props.role,
        });
        if (props.dependable) {
            project.node.addDependency(props.dependable);
        }
        this.action = new codepipeline_actions.CodeBuildAction({
            actionName: props.actionName,
            project,
            input: this.props.cloudAssemblyInput,
            role: props.role,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
        (0, core_1.attachCustomSynthesis)(this, {
            onSynthesize: this._onSynth.bind(this),
        });
    }
    getBuildSpecFileName() {
        return `buildspec-assets-${this.node.path.replace(new RegExp('/', 'g'), '-')}.yaml`;
    }
    _onSynth(session) {
        if (this.props.createBuildspecFile) {
            const specFile = path.join(session.outdir, this.getBuildSpecFileName());
            fs.writeFileSync(specFile, core_1.Stack.of(this).resolve(this.buildSpec.toBuildSpec()), { encoding: 'utf-8' });
        }
    }
    /**
     * Add a single publishing command
     *
     * Manifest path should be relative to the root Cloud Assembly.
     */
    addPublishCommand(relativeManifestPath, assetSelector) {
        const command = `cdk-assets --path "${(0, fs_1.toPosixPath)(relativeManifestPath)}" --verbose publish "${assetSelector}"`;
        if (!this.commands.includes(command)) {
            this.commands.push(command);
        }
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
_a = JSII_RTTI_SYMBOL_1;
PublishAssetsAction[_a] = { fqn: "aws-cdk-lib.pipelines.PublishAssetsAction", version: "2.74.0" };
exports.PublishAssetsAction = PublishAssetsAction;
//# sourceMappingURL=data:application/json;base64,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