"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePipelineAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../../aws-codebuild");
const cpactions = require("../../../../aws-codepipeline-actions");
const iam = require("../../../../aws-iam");
const core_1 = require("../../../../core");
const constructs_1 = require("constructs");
const docker_credentials_1 = require("../../docker-credentials");
const construct_internals_1 = require("../../private/construct-internals");
const default_codebuild_image_1 = require("../../private/default-codebuild-image");
/**
 * Action to self-mutate the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class UpdatePipelineAction extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const stackIdentifier = props.pipelineStackHierarchicalId ?? props.pipelineStackName;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: [
                        `npm install -g aws-cdk${installSuffix}`,
                        ...(0, docker_credentials_1.dockerCredentialsInstallCommands)(docker_credentials_1.DockerCredentialUsage.SELF_UPDATE, props.dockerCredentials),
                    ],
                },
                build: {
                    commands: [
                        // Cloud Assembly is in *current* directory.
                        `cdk -a ${(0, construct_internals_1.embeddedAsmPath)(scope)} deploy ${stackIdentifier} --require-approval=never --verbose`,
                    ],
                },
            },
        });
        const selfMutationProject = new codebuild.PipelineProject(this, 'SelfMutation', {
            projectName: props.projectName,
            environment: {
                buildImage: default_codebuild_image_1.CDKP_DEFAULT_CODEBUILD_IMAGE,
                privileged: props.privileged ?? false,
            },
            buildSpec: props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec,
        });
        // allow the self-mutating project permissions to assume the bootstrap Action role
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: [`arn:*:iam::${core_1.Stack.of(this).account}:role/*`],
            conditions: {
                'ForAnyValue:StringEquals': {
                    'iam:ResourceTag/aws-cdk:bootstrap-role': ['image-publishing', 'file-publishing', 'deploy'],
                },
            },
        }));
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'], // this is needed to check the status of the bootstrap stack when doing `cdk deploy`
        }));
        // S3 checks for the presence of the ListBucket permission
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:ListBucket'],
            resources: ['*'],
        }));
        (props.dockerCredentials ?? []).forEach(reg => reg.grantRead(selfMutationProject, docker_credentials_1.DockerCredentialUsage.SELF_UPDATE));
        this.action = new cpactions.CodeBuildAction({
            actionName: 'SelfMutate',
            input: props.cloudAssemblyInput,
            project: selfMutationProject,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
_a = JSII_RTTI_SYMBOL_1;
UpdatePipelineAction[_a] = { fqn: "aws-cdk-lib.pipelines.UpdatePipelineAction", version: "2.74.0" };
exports.UpdatePipelineAction = UpdatePipelineAction;
//# sourceMappingURL=data:application/json;base64,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