"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShellScriptAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../../aws-codebuild");
const codepipeline = require("../../../../aws-codepipeline");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
const default_codebuild_image_1 = require("../../private/default-codebuild-image");
/**
 * Validate a revision using shell commands
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class ShellScriptAction {
    constructor(props) {
        this.props = props;
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: props.actionName,
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [],
            outputs: [],
        };
        if (Object.keys(props.useOutputs ?? {}).length + (props.additionalArtifacts ?? []).length === 0) {
            throw new Error('You must supply either \'useOutputs\' or \'additionalArtifacts\', since a CodeBuild Action must always have at least one input artifact.');
        }
    }
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal() {
        return this.project.grantPrincipal;
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        return this._actionProperties;
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        const inputs = new Array();
        inputs.push(...this.props.additionalArtifacts ?? []);
        const envVarCommands = new Array();
        const bashOptions = this.props.bashOptions ?? '-eu';
        if (bashOptions) {
            envVarCommands.push(`set ${bashOptions}`);
        }
        for (const [varName, output] of Object.entries(this.props.useOutputs ?? {})) {
            const outputArtifact = output.artifactFile;
            // Add the artifact to the list of inputs, if it's not in there already. Determine
            // the location where CodeBuild is going to stick it based on whether it's the first (primary)
            // input or an 'extra input', then parse.
            let artifactIndex = inputs.findIndex(a => a.artifactName === outputArtifact.artifact.artifactName);
            if (artifactIndex === -1) {
                artifactIndex = inputs.push(outputArtifact.artifact) - 1;
            }
            const dirEnv = artifactIndex === 0 ? 'CODEBUILD_SRC_DIR' : `CODEBUILD_SRC_DIR_${outputArtifact.artifact.artifactName}`;
            envVarCommands.push(`export ${varName}="$(node -pe 'require(process.env.${dirEnv} + "/${outputArtifact.fileName}")["${output.outputName}"]')"`);
        }
        this._project = new codebuild.PipelineProject(scope, 'Project', {
            environment: this.props.environment || { buildImage: default_codebuild_image_1.CDKP_DEFAULT_CODEBUILD_IMAGE },
            vpc: this.props.vpc,
            securityGroups: this.props.securityGroups,
            subnetSelection: this.props.subnetSelection,
            buildSpec: codebuild.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    build: {
                        commands: [
                            ...envVarCommands,
                            ...this.props.commands,
                        ],
                    },
                },
            }),
        });
        for (const statement of this.props.rolePolicyStatements ?? []) {
            this._project.addToRolePolicy(statement);
        }
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.props.actionName,
            input: inputs[0],
            extraInputs: inputs.slice(1),
            runOrder: this.props.runOrder ?? 100,
            project: this._project,
            environmentVariables: this.props.environmentVariables,
        });
        // Replace the placeholder actionProperties at the last minute
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
    }
    /**
     * Project generated to run the shell script in
     */
    get project() {
        if (!this._project) {
            throw new Error('Project becomes available after ShellScriptAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ShellScriptAction[_a] = { fqn: "aws-cdk-lib.pipelines.ShellScriptAction", version: "2.74.0" };
exports.ShellScriptAction = ShellScriptAction;
//# sourceMappingURL=data:application/json;base64,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