"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineBase = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
const blueprint_1 = require("../blueprint");
const PIPELINE_SYMBOL = Symbol.for('@aws-cdk/pipelines.PipelineBase');
/**
 * A generic CDK Pipelines pipeline
 *
 * Different deployment systems will provide subclasses of `Pipeline` that generate
 * the deployment infrastructure necessary to deploy CDK apps, specific to that system.
 *
 * This library comes with the `CodePipeline` class, which uses AWS CodePipeline
 * to deploy CDK apps.
 *
 * The actual pipeline infrastructure is constructed (by invoking the engine)
 * when `buildPipeline()` is called, or when `app.synth()` is called (whichever
 * happens first).
 */
class PipelineBase extends constructs_1.Construct {
    /**
     * Return whether the given object extends `PipelineBase`.
     *
     * We do attribute detection since we can't reliably use 'instanceof'.
     */
    static isPipeline(x) {
        return x !== null && typeof (x) === 'object' && PIPELINE_SYMBOL in x;
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.built = false;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_PipelineBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PipelineBase);
            }
            throw error;
        }
        Object.defineProperty(this, PIPELINE_SYMBOL, { value: true });
        if (props.synth instanceof blueprint_1.ShellStep && !props.synth.primaryOutput) {
            props.synth.primaryOutputDirectory('cdk.out');
        }
        if (!props.synth.primaryOutput) {
            throw new Error(`synthStep ${props.synth} must produce a primary output, but is not producing anything. Configure the Step differently or use a different Step type.`);
        }
        this.synth = props.synth;
        this.waves = [];
        this.cloudAssemblyFileSet = props.synth.primaryOutput;
        core_1.Aspects.of(this).add({ visit: () => this.buildJustInTime() });
    }
    /**
     * Deploy a single Stage by itself
     *
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     */
    addStage(stage, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_Stage(stage);
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_AddStageOpts(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        if (this.built) {
            throw new Error('addStage: can\'t add Stages anymore after buildPipeline() has been called');
        }
        return this.addWave(stage.stageName).addStage(stage, options);
    }
    /**
     * Add a Wave to the pipeline, for deploying multiple Stages in parallel
     *
     * Use the return object of this method to deploy multiple stages in parallel.
     *
     * Example:
     *
     * ```ts
     * declare const pipeline: pipelines.CodePipeline;
     *
     * const wave = pipeline.addWave('MyWave');
     * wave.addStage(new MyApplicationStage(this, 'Stage1'));
     * wave.addStage(new MyApplicationStage(this, 'Stage2'));
     * ```
     */
    addWave(id, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_pipelines_WaveOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addWave);
            }
            throw error;
        }
        if (this.built) {
            throw new Error('addWave: can\'t add Waves anymore after buildPipeline() has been called');
        }
        const wave = new blueprint_1.Wave(id, options);
        this.waves.push(wave);
        return wave;
    }
    /**
     * Send the current pipeline definition to the engine, and construct the pipeline
     *
     * It is not possible to modify the pipeline after calling this method.
     */
    buildPipeline() {
        if (this.built) {
            throw new Error('build() has already been called: can only call it once');
        }
        this.doBuildPipeline();
        this.built = true;
    }
    /**
     * Automatically call 'build()' just before synthesis if the user hasn't explicitly called it yet
     */
    buildJustInTime() {
        if (!this.built) {
            this.buildPipeline();
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
PipelineBase[_a] = { fqn: "aws-cdk-lib.pipelines.PipelineBase", version: "2.74.0" };
exports.PipelineBase = PipelineBase;
//# sourceMappingURL=data:application/json;base64,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