"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CachedFnSub = void 0;
const core_1 = require("../../../core");
/**
 * Wrap a string in `Fn.sub`, but return the same `Fn.sub` value for the same string
 *
 * If we don't do this, every new `Fn.sub()` creates a new `IResolvable` instance
 * which will stringify to a unique string value, and we can't dedupe the stringified
 * values anymore.
 *
 * Potentially we could/should do deduplication in the token system itself, but
 * we would have to be consistent about it and do it for all tokens, which has
 * an unpredictable memory impact and I'm scared of making such a sweeping
 * change. Hence, a local solution to a local problem.
 */
class CachedFnSub {
    constructor() {
        this.cache = new Map();
    }
    fnSub(x) {
        const existing = this.cache.get(x);
        if (existing) {
            return existing;
        }
        const ret = core_1.Fn.sub(x);
        this.cache.set(x, ret);
        return ret;
    }
}
exports.CachedFnSub = CachedFnSub;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGVkLWZuc3ViLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2FjaGVkLWZuc3ViLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUFtQztBQUVuQzs7Ozs7Ozs7Ozs7R0FXRztBQUNILE1BQWEsV0FBVztJQUF4QjtRQUNVLFVBQUssR0FBRyxJQUFJLEdBQUcsRUFBa0IsQ0FBQztJQVk1QyxDQUFDO0lBVlEsS0FBSyxDQUFDLENBQVM7UUFDcEIsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDbkMsSUFBSSxRQUFRLEVBQUU7WUFDWixPQUFPLFFBQVEsQ0FBQztTQUNqQjtRQUVELE1BQU0sR0FBRyxHQUFHLFNBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDdEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3ZCLE9BQU8sR0FBRyxDQUFDO0tBQ1o7Q0FDRjtBQWJELGtDQWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRm4gfSBmcm9tICcuLi8uLi8uLi9jb3JlJztcblxuLyoqXG4gKiBXcmFwIGEgc3RyaW5nIGluIGBGbi5zdWJgLCBidXQgcmV0dXJuIHRoZSBzYW1lIGBGbi5zdWJgIHZhbHVlIGZvciB0aGUgc2FtZSBzdHJpbmdcbiAqXG4gKiBJZiB3ZSBkb24ndCBkbyB0aGlzLCBldmVyeSBuZXcgYEZuLnN1YigpYCBjcmVhdGVzIGEgbmV3IGBJUmVzb2x2YWJsZWAgaW5zdGFuY2VcbiAqIHdoaWNoIHdpbGwgc3RyaW5naWZ5IHRvIGEgdW5pcXVlIHN0cmluZyB2YWx1ZSwgYW5kIHdlIGNhbid0IGRlZHVwZSB0aGUgc3RyaW5naWZpZWRcbiAqIHZhbHVlcyBhbnltb3JlLlxuICpcbiAqIFBvdGVudGlhbGx5IHdlIGNvdWxkL3Nob3VsZCBkbyBkZWR1cGxpY2F0aW9uIGluIHRoZSB0b2tlbiBzeXN0ZW0gaXRzZWxmLCBidXRcbiAqIHdlIHdvdWxkIGhhdmUgdG8gYmUgY29uc2lzdGVudCBhYm91dCBpdCBhbmQgZG8gaXQgZm9yIGFsbCB0b2tlbnMsIHdoaWNoIGhhc1xuICogYW4gdW5wcmVkaWN0YWJsZSBtZW1vcnkgaW1wYWN0IGFuZCBJJ20gc2NhcmVkIG9mIG1ha2luZyBzdWNoIGEgc3dlZXBpbmdcbiAqIGNoYW5nZS4gSGVuY2UsIGEgbG9jYWwgc29sdXRpb24gdG8gYSBsb2NhbCBwcm9ibGVtLlxuICovXG5leHBvcnQgY2xhc3MgQ2FjaGVkRm5TdWIge1xuICBwcml2YXRlIGNhY2hlID0gbmV3IE1hcDxzdHJpbmcsIHN0cmluZz4oKTtcblxuICBwdWJsaWMgZm5TdWIoeDogc3RyaW5nKSB7XG4gICAgY29uc3QgZXhpc3RpbmcgPSB0aGlzLmNhY2hlLmdldCh4KTtcbiAgICBpZiAoZXhpc3RpbmcpIHtcbiAgICAgIHJldHVybiBleGlzdGluZztcbiAgICB9XG5cbiAgICBjb25zdCByZXQgPSBGbi5zdWIoeCk7XG4gICAgdGhpcy5jYWNoZS5zZXQoeCwgcmV0KTtcbiAgICByZXR1cm4gcmV0O1xuICB9XG59Il19