"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.obtainScope = exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.pipelineSynth = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const path = require("path");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
function appOf(construct) {
    const root = constructs_1.Node.of(construct).root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${constructs_1.Node.of(construct).path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
function pipelineSynth(stage) {
    return stage.synth({ validateOnSynthesis: true });
}
exports.pipelineSynth = pipelineSynth;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = core_1.Stage.of(scope) ?? appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
function obtainScope(parent, id) {
    const existing = constructs_1.Node.of(parent).tryFindChild(id);
    if (existing) {
        return existing;
    }
    return new constructs_1.Construct(parent, id);
}
exports.obtainScope = obtainScope;
//# sourceMappingURL=data:application/json;base64,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