"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDefined = exports.partition = exports.maybeSuffix = exports.noUndefined = exports.noEmptyObject = exports.mkdict = exports.mapValues = exports.filterEmpty = exports.flatten = exports.expectProp = exports.enumerate = exports.flatMap = exports.extract = exports.addAll = void 0;
function addAll(into, from) {
    for (const x of from) {
        into.add(x);
    }
}
exports.addAll = addAll;
function extract(from, key) {
    const ret = from.get(key);
    from.delete(key);
    return ret;
}
exports.extract = extract;
function* flatMap(xs, fn) {
    for (const x of xs) {
        for (const y of fn(x)) {
            yield y;
        }
    }
}
exports.flatMap = flatMap;
function* enumerate(xs) {
    let i = 0;
    for (const x of xs) {
        yield [i++, x];
    }
}
exports.enumerate = enumerate;
function expectProp(obj, key) {
    if (!obj[key]) {
        throw new Error(`Expecting '${String(key)}' to be set!`);
    }
    return obj[key];
}
exports.expectProp = expectProp;
function* flatten(xs) {
    for (const x of xs) {
        for (const y of x) {
            yield y;
        }
    }
}
exports.flatten = flatten;
function filterEmpty(xs) {
    return xs.filter(x => x);
}
exports.filterEmpty = filterEmpty;
function mapValues(xs, fn) {
    const ret = {};
    for (const [k, v] of Object.entries(xs)) {
        ret[k] = fn(v);
    }
    return ret;
}
exports.mapValues = mapValues;
function mkdict(xs) {
    const ret = {};
    for (const [k, v] of xs) {
        ret[k] = v;
    }
    return ret;
}
exports.mkdict = mkdict;
function noEmptyObject(xs) {
    if (Object.keys(xs).length === 0) {
        return undefined;
    }
    return xs;
}
exports.noEmptyObject = noEmptyObject;
function noUndefined(xs) {
    return mkdict(Object.entries(xs).filter(([_, v]) => isDefined(v)));
}
exports.noUndefined = noUndefined;
function maybeSuffix(x, suffix) {
    if (x === undefined) {
        return undefined;
    }
    return `${x}${suffix}`;
}
exports.maybeSuffix = maybeSuffix;
/**
 * Partition a collection by dividing it into two collections, one that matches the predicate and one that don't
 */
function partition(xs, pred) {
    const yes = [];
    const no = [];
    for (const x of xs) {
        (pred(x) ? yes : no).push(x);
    }
    return [yes, no];
}
exports.partition = partition;
function isDefined(x) {
    return x !== undefined;
}
exports.isDefined = isDefined;
//# sourceMappingURL=data:application/json;base64,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