"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides default values for certain regional information points.
 */
class Default {
    /**
     * Computes a "standard" AWS Service principal for a given service, region and suffix. This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param serviceFqn the name of the service (s3, s3.amazonaws.com, ...)
     * @param region    the region in which the service principal is needed.
     * @param urlSuffix deprecated and ignored.
     */
    static servicePrincipal(serviceFqn, region, urlSuffix) {
        // NOTE: this whole method is deprecated, and should not be used or updated anymore. The global service
        // principal is always correct, when referenced from within a region.
        // (As a note, regional principals (`<SERVICE>.<REGION>.amazonaws.com`) are required in
        // case of a cross-region reference to an opt-in region, but that's the only case, and that is not
        // controlled here).
        //
        // (It cannot be actually @deprecated since many of our tests use it :D)
        const serviceName = extractSimpleName(serviceFqn);
        if (!serviceName) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return serviceFqn;
        }
        function determineConfiguration(service) {
            function universal(s) { return `${s}.amazonaws.com`; }
            function partitional(s, _, u) { return `${s}.${u}`; }
            function regional(s, r) { return `${s}.${r}.amazonaws.com`; }
            function regionalPartitional(s, r, u) { return `${s}.${r}.${u}`; }
            // Exceptions for Service Principals in us-iso-*
            const US_ISO_EXCEPTIONS = new Set([
                'cloudhsm',
                'config',
                'states',
                'workspaces',
            ]);
            // Account for idiosyncratic Service Principals in `us-iso-*` regions
            if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
                switch (service) {
                    // Services with universal principal
                    case ('states'):
                        return universal;
                    // Services with a partitional principal
                    default:
                        return partitional;
                }
            }
            // Exceptions for Service Principals in us-isob-*
            const US_ISOB_EXCEPTIONS = new Set([
                'dms',
                'states',
            ]);
            // Account for idiosyncratic Service Principals in `us-isob-*` regions
            if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
                switch (service) {
                    // Services with universal principal
                    case ('states'):
                        return universal;
                    // Services with a partitional principal
                    default:
                        return partitional;
                }
            }
            switch (service) {
                // CodeDeploy is regional+partitional in CN, only regional everywhere else
                case 'codedeploy':
                    return region.startsWith('cn-')
                        ? regionalPartitional
                        // ...except in the isolated regions, where it's universal
                        : (region.startsWith('us-iso') ? universal : regional);
                // Services with a regional AND partitional principal
                case 'logs':
                    return regionalPartitional;
                // Services with a regional principal
                case 'states':
                    return regional;
                case 'elasticmapreduce':
                    return region.startsWith('cn-')
                        ? partitional
                        : universal;
                // Services with a universal principal across all regions/partitions (the default case)
                default:
                    return universal;
            }
        }
        ;
        const configuration = determineConfiguration(serviceName);
        return configuration(serviceName, region, urlSuffix);
    }
    constructor() { }
}
_a = JSII_RTTI_SYMBOL_1;
Default[_a] = { fqn: "aws-cdk-lib.region_info.Default", version: "2.74.0" };
/**
 * The default value for a VPC Endpoint Service name prefix, useful if you do
 * not have a synthesize-time region literal available (all you have is
 * `{ "Ref": "AWS::Region" }`)
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
exports.Default = Default;
function extractSimpleName(serviceFqn) {
    const matches = serviceFqn.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
    return matches ? matches[1] : undefined;
}
//# sourceMappingURL=data:application/json;base64,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