"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerFunction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const lambda = require("../../aws-lambda");
/**
 * Invokes an AWS Lambda function during deployment.
 */
class TriggerFunction extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_triggers_TriggerFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TriggerFunction);
            }
            throw error;
        }
        this.trigger = new _1.Trigger(this, 'Trigger', {
            ...props,
            handler: this,
        });
    }
    executeAfter(...scopes) {
        this.trigger.executeAfter(...scopes);
    }
    executeBefore(...scopes) {
        this.trigger.executeBefore(...scopes);
    }
}
_a = JSII_RTTI_SYMBOL_1;
TriggerFunction[_a] = { fqn: "aws-cdk-lib.triggers.TriggerFunction", version: "2.74.0" };
exports.TriggerFunction = TriggerFunction;
//# sourceMappingURL=data:application/json;base64,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