"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerInvalidation = exports.Trigger = exports.InvocationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const constructs_1 = require("constructs");
const core_1 = require("../../core");
/**
 * The invocation type to apply to a trigger. This determines whether the trigger function should await the result of the to be triggered function or not.
 */
var InvocationType;
(function (InvocationType) {
    /**
     * Invoke the function synchronously. Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    InvocationType["EVENT"] = "Event";
    /**
     * Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if one is configured).
     * The API response only includes a status code.
     */
    InvocationType["REQUEST_RESPONSE"] = "RequestResponse";
    /**
     *  Validate parameter values and verify that the user or role has permission to invoke the function.
     */
    InvocationType["DRY_RUN"] = "DryRun";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
/**
 * Triggers an AWS Lambda function during deployment.
 */
class Trigger extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_triggers_TriggerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Trigger);
            }
            throw error;
        }
        const handlerArn = this.determineHandlerArn(props);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: (0, path_1.join)(__dirname, 'lambda'),
        });
        provider.addToRolePolicy({
            Effect: 'Allow',
            Action: ['lambda:InvokeFunction'],
            Resource: [`${props.handler.functionArn}:*`],
        });
        new core_1.CustomResource(this, 'Default', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                HandlerArn: handlerArn,
                InvocationType: props.invocationType ?? 'RequestResponse',
                Timeout: props.timeout?.toMilliseconds().toString() ?? core_1.Duration.minutes(2).toMilliseconds().toString(),
            },
        });
        this.executeAfter(...props.executeAfter ?? []);
        this.executeBefore(...props.executeBefore ?? []);
    }
    executeAfter(...scopes) {
        constructs_1.Node.of(this).addDependency(...scopes);
    }
    executeBefore(...scopes) {
        for (const s of scopes) {
            constructs_1.Node.of(s).addDependency(this);
        }
    }
    determineHandlerArn(props) {
        return props.handler.currentVersion.functionArn;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Trigger[_a] = { fqn: "aws-cdk-lib.triggers.Trigger", version: "2.74.0" };
exports.Trigger = Trigger;
/**
 * Determines
 */
var TriggerInvalidation;
(function (TriggerInvalidation) {
    /**
     * The trigger will be executed every time the handler (or its configuration)
     * changes. This is implemented by associated the trigger with the `currentVersion`
     * of the AWS Lambda function, which gets recreated every time the handler changes.
     */
    TriggerInvalidation["HANDLER_CHANGE"] = "WHEN_FUNCTION_CHANGES";
})(TriggerInvalidation = exports.TriggerInvalidation || (exports.TriggerInvalidation = {}));
//# sourceMappingURL=data:application/json;base64,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