'''
# AWS::QuickSight Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_quicksight as quicksight
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for QuickSight construct libraries](https://constructs.dev/search?q=quicksight)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::QuickSight resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_QuickSight.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::QuickSight](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_QuickSight.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import constructs as _constructs_77d1e7e8
from .. import (
    CfnResource as _CfnResource_9df397a6,
    CfnTag as _CfnTag_f6864754,
    IInspectable as _IInspectable_c2943556,
    IResolvable as _IResolvable_da3f097b,
    TagManager as _TagManager_0a598cb3,
    TreeInspector as _TreeInspector_488e0dd5,
)


@jsii.implements(_IInspectable_c2943556)
class CfnAnalysis(
    _CfnResource_9df397a6,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-cdk-lib.aws_quicksight.CfnAnalysis",
):
    '''A CloudFormation ``AWS::QuickSight::Analysis``.

    Creates an analysis in Amazon QuickSight.

    :cloudformationResource: AWS::QuickSight::Analysis
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from aws_cdk import aws_quicksight as quicksight
        
        # data_driven: Any
        
        cfn_analysis = quicksight.CfnAnalysis(self, "MyCfnAnalysis",
            analysis_id="analysisId",
            aws_account_id="awsAccountId",
            name="name",
        
            # the properties below are optional
            definition=quicksight.CfnAnalysis.AnalysisDefinitionProperty(
                data_set_identifier_declarations=[quicksight.CfnAnalysis.DataSetIdentifierDeclarationProperty(
                    data_set_arn="dataSetArn",
                    identifier="identifier"
                )],
        
                # the properties below are optional
                analysis_defaults=quicksight.CfnAnalysis.AnalysisDefaultsProperty(
                    default_new_sheet_configuration=quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty(
                        interactive_layout_configuration=quicksight.CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty(
                            free_form=quicksight.CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            ),
                            grid=quicksight.CfnAnalysis.DefaultGridLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                        resize_option="resizeOption",
        
                                        # the properties below are optional
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            )
                        ),
                        paginated_layout_configuration=quicksight.CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty(
                            section_based=quicksight.CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty(
                                canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                                    paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                                        paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        ),
                                        paper_orientation="paperOrientation",
                                        paper_size="paperSize"
                                    )
                                )
                            )
                        ),
                        sheet_content_type="sheetContentType"
                    )
                ),
                calculated_fields=[quicksight.CfnAnalysis.CalculatedFieldProperty(
                    data_set_identifier="dataSetIdentifier",
                    expression="expression",
                    name="name"
                )],
                column_configurations=[quicksight.CfnAnalysis.ColumnConfigurationProperty(
                    column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                        column_name="columnName",
                        data_set_identifier="dataSetIdentifier"
                    ),
        
                    # the properties below are optional
                    colors_configuration=quicksight.CfnAnalysis.ColorsConfigurationProperty(
                        custom_colors=[quicksight.CfnAnalysis.CustomColorProperty(
                            color="color",
        
                            # the properties below are optional
                            field_value="fieldValue",
                            special_value="specialValue"
                        )]
                    ),
                    format_configuration=quicksight.CfnAnalysis.FormatConfigurationProperty(
                        date_time_format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                            date_time_format="dateTimeFormat",
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        number_format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                            format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        ),
                        string_format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                null_string="nullString"
                            ),
                            numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix",
                                    symbol="symbol"
                                ),
                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    number_scale="numberScale",
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                ),
                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                        decimal_places=123
                                    ),
                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                        display_mode="displayMode"
                                    ),
                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                        null_string="nullString"
                                    ),
                                    prefix="prefix",
                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                        decimal_separator="decimalSeparator",
                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                            symbol="symbol",
                                            visibility="visibility"
                                        )
                                    ),
                                    suffix="suffix"
                                )
                            )
                        )
                    ),
                    role="role"
                )],
                filter_groups=[quicksight.CfnAnalysis.FilterGroupProperty(
                    cross_dataset="crossDataset",
                    filter_group_id="filterGroupId",
                    filters=[quicksight.CfnAnalysis.FilterProperty(
                        category_filter=quicksight.CfnAnalysis.CategoryFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            configuration=quicksight.CfnAnalysis.CategoryFilterConfigurationProperty(
                                custom_filter_configuration=quicksight.CfnAnalysis.CustomFilterConfigurationProperty(
                                    match_operator="matchOperator",
                                    null_option="nullOption",
        
                                    # the properties below are optional
                                    category_value="categoryValue",
                                    parameter_name="parameterName",
                                    select_all_options="selectAllOptions"
                                ),
                                custom_filter_list_configuration=quicksight.CfnAnalysis.CustomFilterListConfigurationProperty(
                                    match_operator="matchOperator",
                                    null_option="nullOption",
        
                                    # the properties below are optional
                                    category_values=["categoryValues"],
                                    select_all_options="selectAllOptions"
                                ),
                                filter_list_configuration=quicksight.CfnAnalysis.FilterListConfigurationProperty(
                                    match_operator="matchOperator",
        
                                    # the properties below are optional
                                    category_values=["categoryValues"],
                                    select_all_options="selectAllOptions"
                                )
                            ),
                            filter_id="filterId"
                        ),
                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
                            match_operator="matchOperator",
                            null_option="nullOption",
        
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            ),
                            parameter_name="parameterName",
                            select_all_options="selectAllOptions",
                            value=123
                        ),
                        numeric_range_filter=quicksight.CfnAnalysis.NumericRangeFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
                            null_option="nullOption",
        
                            # the properties below are optional
                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                categorical_aggregation_function="categoricalAggregationFunction",
                                date_aggregation_function="dateAggregationFunction",
                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                        percentile_value=123
                                    ),
                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                )
                            ),
                            include_maximum=False,
                            include_minimum=False,
                            range_maximum=quicksight.CfnAnalysis.NumericRangeFilterValueProperty(
                                parameter="parameter",
                                static_value=123
                            ),
                            range_minimum=quicksight.CfnAnalysis.NumericRangeFilterValueProperty(
                                parameter="parameter",
                                static_value=123
                            ),
                            select_all_options="selectAllOptions"
                        ),
                        relative_dates_filter=quicksight.CfnAnalysis.RelativeDatesFilterProperty(
                            anchor_date_configuration=quicksight.CfnAnalysis.AnchorDateConfigurationProperty(
                                anchor_option="anchorOption",
                                parameter_name="parameterName"
                            ),
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
                            null_option="nullOption",
                            relative_date_type="relativeDateType",
                            time_granularity="timeGranularity",
        
                            # the properties below are optional
                            exclude_period_configuration=quicksight.CfnAnalysis.ExcludePeriodConfigurationProperty(
                                amount=123,
                                granularity="granularity",
        
                                # the properties below are optional
                                status="status"
                            ),
                            minimum_granularity="minimumGranularity",
                            parameter_name="parameterName",
                            relative_date_value=123
                        ),
                        time_equality_filter=quicksight.CfnAnalysis.TimeEqualityFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
        
                            # the properties below are optional
                            parameter_name="parameterName",
                            time_granularity="timeGranularity",
                            value="value"
                        ),
                        time_range_filter=quicksight.CfnAnalysis.TimeRangeFilterProperty(
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
                            null_option="nullOption",
        
                            # the properties below are optional
                            exclude_period_configuration=quicksight.CfnAnalysis.ExcludePeriodConfigurationProperty(
                                amount=123,
                                granularity="granularity",
        
                                # the properties below are optional
                                status="status"
                            ),
                            include_maximum=False,
                            include_minimum=False,
                            range_maximum_value=quicksight.CfnAnalysis.TimeRangeFilterValueProperty(
                                parameter="parameter",
                                rolling_date=quicksight.CfnAnalysis.RollingDateConfigurationProperty(
                                    expression="expression",
        
                                    # the properties below are optional
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                static_value="staticValue"
                            ),
                            range_minimum_value=quicksight.CfnAnalysis.TimeRangeFilterValueProperty(
                                parameter="parameter",
                                rolling_date=quicksight.CfnAnalysis.RollingDateConfigurationProperty(
                                    expression="expression",
        
                                    # the properties below are optional
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                static_value="staticValue"
                            ),
                            time_granularity="timeGranularity"
                        ),
                        top_bottom_filter=quicksight.CfnAnalysis.TopBottomFilterProperty(
                            aggregation_sort_configurations=[quicksight.CfnAnalysis.AggregationSortConfigurationProperty(
                                aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                    categorical_aggregation_function="categoricalAggregationFunction",
                                    date_aggregation_function="dateAggregationFunction",
                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                            percentile_value=123
                                        ),
                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                    )
                                ),
                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                sort_direction="sortDirection"
                            )],
                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                column_name="columnName",
                                data_set_identifier="dataSetIdentifier"
                            ),
                            filter_id="filterId",
        
                            # the properties below are optional
                            limit=123,
                            parameter_name="parameterName",
                            time_granularity="timeGranularity"
                        )
                    )],
                    scope_configuration=quicksight.CfnAnalysis.FilterScopeConfigurationProperty(
                        selected_sheets=quicksight.CfnAnalysis.SelectedSheetsFilterScopeConfigurationProperty(
                            sheet_visual_scoping_configurations=[quicksight.CfnAnalysis.SheetVisualScopingConfigurationProperty(
                                scope="scope",
                                sheet_id="sheetId",
        
                                # the properties below are optional
                                visual_ids=["visualIds"]
                            )]
                        )
                    ),
        
                    # the properties below are optional
                    status="status"
                )],
                parameter_declarations=[quicksight.CfnAnalysis.ParameterDeclarationProperty(
                    date_time_parameter_declaration=quicksight.CfnAnalysis.DateTimeParameterDeclarationProperty(
                        name="name",
        
                        # the properties below are optional
                        default_values=quicksight.CfnAnalysis.DateTimeDefaultValuesProperty(
                            dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                                default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
        
                                # the properties below are optional
                                group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            rolling_date=quicksight.CfnAnalysis.RollingDateConfigurationProperty(
                                expression="expression",
        
                                # the properties below are optional
                                data_set_identifier="dataSetIdentifier"
                            ),
                            static_values=["staticValues"]
                        ),
                        mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                            data_set_identifier="dataSetIdentifier",
                            data_set_parameter_name="dataSetParameterName"
                        )],
                        time_granularity="timeGranularity",
                        value_when_unset=quicksight.CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty(
                            custom_value="customValue",
                            value_when_unset_option="valueWhenUnsetOption"
                        )
                    ),
                    decimal_parameter_declaration=quicksight.CfnAnalysis.DecimalParameterDeclarationProperty(
                        name="name",
                        parameter_value_type="parameterValueType",
        
                        # the properties below are optional
                        default_values=quicksight.CfnAnalysis.DecimalDefaultValuesProperty(
                            dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                                default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
        
                                # the properties below are optional
                                group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            static_values=[123]
                        ),
                        mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                            data_set_identifier="dataSetIdentifier",
                            data_set_parameter_name="dataSetParameterName"
                        )],
                        value_when_unset=quicksight.CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty(
                            custom_value=123,
                            value_when_unset_option="valueWhenUnsetOption"
                        )
                    ),
                    integer_parameter_declaration=quicksight.CfnAnalysis.IntegerParameterDeclarationProperty(
                        name="name",
                        parameter_value_type="parameterValueType",
        
                        # the properties below are optional
                        default_values=quicksight.CfnAnalysis.IntegerDefaultValuesProperty(
                            dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                                default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
        
                                # the properties below are optional
                                group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            static_values=[123]
                        ),
                        mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                            data_set_identifier="dataSetIdentifier",
                            data_set_parameter_name="dataSetParameterName"
                        )],
                        value_when_unset=quicksight.CfnAnalysis.IntegerValueWhenUnsetConfigurationProperty(
                            custom_value=123,
                            value_when_unset_option="valueWhenUnsetOption"
                        )
                    ),
                    string_parameter_declaration=quicksight.CfnAnalysis.StringParameterDeclarationProperty(
                        name="name",
                        parameter_value_type="parameterValueType",
        
                        # the properties below are optional
                        default_values=quicksight.CfnAnalysis.StringDefaultValuesProperty(
                            dynamic_value=quicksight.CfnAnalysis.DynamicDefaultValueProperty(
                                default_value_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
        
                                # the properties below are optional
                                group_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                user_name_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                )
                            ),
                            static_values=["staticValues"]
                        ),
                        mapped_data_set_parameters=[quicksight.CfnAnalysis.MappedDataSetParameterProperty(
                            data_set_identifier="dataSetIdentifier",
                            data_set_parameter_name="dataSetParameterName"
                        )],
                        value_when_unset=quicksight.CfnAnalysis.StringValueWhenUnsetConfigurationProperty(
                            custom_value="customValue",
                            value_when_unset_option="valueWhenUnsetOption"
                        )
                    )
                )],
                sheets=[quicksight.CfnAnalysis.SheetDefinitionProperty(
                    sheet_id="sheetId",
        
                    # the properties below are optional
                    content_type="contentType",
                    description="description",
                    filter_controls=[quicksight.CfnAnalysis.FilterControlProperty(
                        date_time_picker=quicksight.CfnAnalysis.FilterDateTimePickerControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                                date_time_format="dateTimeFormat",
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            type="type"
                        ),
                        dropdown=quicksight.CfnAnalysis.FilterDropDownControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            cascading_control_configuration=quicksight.CfnAnalysis.CascadingControlConfigurationProperty(
                                source_controls=[quicksight.CfnAnalysis.CascadingControlSourceProperty(
                                    column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                                    source_sheet_control_id="sourceSheetControlId"
                                )]
                            ),
                            display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                values=["values"]
                            ),
                            type="type"
                        ),
                        list=quicksight.CfnAnalysis.FilterListControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            cascading_control_configuration=quicksight.CfnAnalysis.CascadingControlConfigurationProperty(
                                source_controls=[quicksight.CfnAnalysis.CascadingControlSourceProperty(
                                    column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                                    source_sheet_control_id="sourceSheetControlId"
                                )]
                            ),
                            display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                                search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                    visibility="visibility"
                                ),
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.FilterSelectableValuesProperty(
                                values=["values"]
                            ),
                            type="type"
                        ),
                        relative_date_time=quicksight.CfnAnalysis.FilterRelativeDateTimeControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty(
                                date_time_format="dateTimeFormat",
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        slider=quicksight.CfnAnalysis.FilterSliderControlProperty(
                            filter_control_id="filterControlId",
                            maximum_value=123,
                            minimum_value=123,
                            source_filter_id="sourceFilterId",
                            step_size=123,
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            type="type"
                        ),
                        text_area=quicksight.CfnAnalysis.FilterTextAreaControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            delimiter="delimiter",
                            display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        text_field=quicksight.CfnAnalysis.FilterTextFieldControlProperty(
                            filter_control_id="filterControlId",
                            source_filter_id="sourceFilterId",
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        )
                    )],
                    layouts=[quicksight.CfnAnalysis.LayoutProperty(
                        configuration=quicksight.CfnAnalysis.LayoutConfigurationProperty(
                            free_form_layout=quicksight.CfnAnalysis.FreeFormLayoutConfigurationProperty(
                                elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                    element_id="elementId",
                                    element_type="elementType",
                                    height="height",
                                    width="width",
                                    x_axis_location="xAxisLocation",
                                    y_axis_location="yAxisLocation",
        
                                    # the properties below are optional
                                    background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                        visibility="visibility"
                                    ),
                                    rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                        configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                            visibility="visibility"
                                        ),
                                        expression="expression"
                                    )],
                                    selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                        color="color",
                                        visibility="visibility"
                                    ),
                                    visibility="visibility"
                                )],
        
                                # the properties below are optional
                                canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty(
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            ),
                            grid_layout=quicksight.CfnAnalysis.GridLayoutConfigurationProperty(
                                elements=[quicksight.CfnAnalysis.GridLayoutElementProperty(
                                    column_span=123,
                                    element_id="elementId",
                                    element_type="elementType",
                                    row_span=123,
        
                                    # the properties below are optional
                                    column_index=123,
                                    row_index=123
                                )],
        
                                # the properties below are optional
                                canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                        resize_option="resizeOption",
        
                                        # the properties below are optional
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            ),
                            section_based_layout=quicksight.CfnAnalysis.SectionBasedLayoutConfigurationProperty(
                                body_sections=[quicksight.CfnAnalysis.BodySectionConfigurationProperty(
                                    content=quicksight.CfnAnalysis.BodySectionContentProperty(
                                        layout=quicksight.CfnAnalysis.SectionLayoutConfigurationProperty(
                                            free_form_layout=quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty(
                                                elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                                    element_id="elementId",
                                                    element_type="elementType",
                                                    height="height",
                                                    width="width",
                                                    x_axis_location="xAxisLocation",
                                                    y_axis_location="yAxisLocation",
        
                                                    # the properties below are optional
                                                    background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                                        color="color",
                                                        visibility="visibility"
                                                    ),
                                                    border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                        color="color",
                                                        visibility="visibility"
                                                    ),
                                                    loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                                        visibility="visibility"
                                                    ),
                                                    rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                                        configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                                            visibility="visibility"
                                                        ),
                                                        expression="expression"
                                                    )],
                                                    selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                        color="color",
                                                        visibility="visibility"
                                                    ),
                                                    visibility="visibility"
                                                )]
                                            )
                                        )
                                    ),
                                    section_id="sectionId",
        
                                    # the properties below are optional
                                    page_break_configuration=quicksight.CfnAnalysis.SectionPageBreakConfigurationProperty(
                                        after=quicksight.CfnAnalysis.SectionAfterPageBreakProperty(
                                            status="status"
                                        )
                                    ),
                                    style=quicksight.CfnAnalysis.SectionStyleProperty(
                                        height="height",
                                        padding=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        )
                                    )
                                )],
                                canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty(
                                    paper_canvas_size_options=quicksight.CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty(
                                        paper_margin=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        ),
                                        paper_orientation="paperOrientation",
                                        paper_size="paperSize"
                                    )
                                ),
                                footer_sections=[quicksight.CfnAnalysis.HeaderFooterSectionConfigurationProperty(
                                    layout=quicksight.CfnAnalysis.SectionLayoutConfigurationProperty(
                                        free_form_layout=quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty(
                                            elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                                element_id="elementId",
                                                element_type="elementType",
                                                height="height",
                                                width="width",
                                                x_axis_location="xAxisLocation",
                                                y_axis_location="yAxisLocation",
        
                                                # the properties below are optional
                                                background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                                    visibility="visibility"
                                                ),
                                                rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                                    configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                                        visibility="visibility"
                                                    ),
                                                    expression="expression"
                                                )],
                                                selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                visibility="visibility"
                                            )]
                                        )
                                    ),
                                    section_id="sectionId",
        
                                    # the properties below are optional
                                    style=quicksight.CfnAnalysis.SectionStyleProperty(
                                        height="height",
                                        padding=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        )
                                    )
                                )],
                                header_sections=[quicksight.CfnAnalysis.HeaderFooterSectionConfigurationProperty(
                                    layout=quicksight.CfnAnalysis.SectionLayoutConfigurationProperty(
                                        free_form_layout=quicksight.CfnAnalysis.FreeFormSectionLayoutConfigurationProperty(
                                            elements=[quicksight.CfnAnalysis.FreeFormLayoutElementProperty(
                                                element_id="elementId",
                                                element_type="elementType",
                                                height="height",
                                                width="width",
                                                x_axis_location="xAxisLocation",
                                                y_axis_location="yAxisLocation",
        
                                                # the properties below are optional
                                                background_style=quicksight.CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                loading_animation=quicksight.CfnAnalysis.LoadingAnimationProperty(
                                                    visibility="visibility"
                                                ),
                                                rendering_rules=[quicksight.CfnAnalysis.SheetElementRenderingRuleProperty(
                                                    configuration_overrides=quicksight.CfnAnalysis.SheetElementConfigurationOverridesProperty(
                                                        visibility="visibility"
                                                    ),
                                                    expression="expression"
                                                )],
                                                selected_border_style=quicksight.CfnAnalysis.FreeFormLayoutElementBorderStyleProperty(
                                                    color="color",
                                                    visibility="visibility"
                                                ),
                                                visibility="visibility"
                                            )]
                                        )
                                    ),
                                    section_id="sectionId",
        
                                    # the properties below are optional
                                    style=quicksight.CfnAnalysis.SectionStyleProperty(
                                        height="height",
                                        padding=quicksight.CfnAnalysis.SpacingProperty(
                                            bottom="bottom",
                                            left="left",
                                            right="right",
                                            top="top"
                                        )
                                    )
                                )]
                            )
                        )
                    )],
                    name="name",
                    parameter_controls=[quicksight.CfnAnalysis.ParameterControlProperty(
                        date_time_picker=quicksight.CfnAnalysis.ParameterDateTimePickerControlProperty(
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.DateTimePickerControlDisplayOptionsProperty(
                                date_time_format="dateTimeFormat",
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        dropdown=quicksight.CfnAnalysis.ParameterDropDownControlProperty(
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            title="title",
        
                            # the properties below are optional
                            cascading_control_configuration=quicksight.CfnAnalysis.CascadingControlConfigurationProperty(
                                source_controls=[quicksight.CfnAnalysis.CascadingControlSourceProperty(
                                    column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                                    source_sheet_control_id="sourceSheetControlId"
                                )]
                            ),
                            display_options=quicksight.CfnAnalysis.DropDownControlDisplayOptionsProperty(
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.ParameterSelectableValuesProperty(
                                link_to_data_set_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                values=["values"]
                            ),
                            type="type"
                        ),
                        list=quicksight.CfnAnalysis.ParameterListControlProperty(
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            title="title",
        
                            # the properties below are optional
                            cascading_control_configuration=quicksight.CfnAnalysis.CascadingControlConfigurationProperty(
                                source_controls=[quicksight.CfnAnalysis.CascadingControlSourceProperty(
                                    column_to_match=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    ),
                                    source_sheet_control_id="sourceSheetControlId"
                                )]
                            ),
                            display_options=quicksight.CfnAnalysis.ListControlDisplayOptionsProperty(
                                search_options=quicksight.CfnAnalysis.ListControlSearchOptionsProperty(
                                    visibility="visibility"
                                ),
                                select_all_options=quicksight.CfnAnalysis.ListControlSelectAllOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            ),
                            selectable_values=quicksight.CfnAnalysis.ParameterSelectableValuesProperty(
                                link_to_data_set_column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                    column_name="columnName",
                                    data_set_identifier="dataSetIdentifier"
                                ),
                                values=["values"]
                            ),
                            type="type"
                        ),
                        slider=quicksight.CfnAnalysis.ParameterSliderControlProperty(
                            maximum_value=123,
                            minimum_value=123,
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            step_size=123,
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.SliderControlDisplayOptionsProperty(
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        text_area=quicksight.CfnAnalysis.ParameterTextAreaControlProperty(
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            title="title",
        
                            # the properties below are optional
                            delimiter="delimiter",
                            display_options=quicksight.CfnAnalysis.TextAreaControlDisplayOptionsProperty(
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        ),
                        text_field=quicksight.CfnAnalysis.ParameterTextFieldControlProperty(
                            parameter_control_id="parameterControlId",
                            source_parameter_name="sourceParameterName",
                            title="title",
        
                            # the properties below are optional
                            display_options=quicksight.CfnAnalysis.TextFieldControlDisplayOptionsProperty(
                                placeholder_options=quicksight.CfnAnalysis.TextControlPlaceholderOptionsProperty(
                                    visibility="visibility"
                                ),
                                title_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                    custom_label="customLabel",
                                    font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    visibility="visibility"
                                )
                            )
                        )
                    )],
                    sheet_control_layouts=[quicksight.CfnAnalysis.SheetControlLayoutProperty(
                        configuration=quicksight.CfnAnalysis.SheetControlLayoutConfigurationProperty(
                            grid_layout=quicksight.CfnAnalysis.GridLayoutConfigurationProperty(
                                elements=[quicksight.CfnAnalysis.GridLayoutElementProperty(
                                    column_span=123,
                                    element_id="elementId",
                                    element_type="elementType",
                                    row_span=123,
        
                                    # the properties below are optional
                                    column_index=123,
                                    row_index=123
                                )],
        
                                # the properties below are optional
                                canvas_size_options=quicksight.CfnAnalysis.GridLayoutCanvasSizeOptionsProperty(
                                    screen_canvas_size_options=quicksight.CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty(
                                        resize_option="resizeOption",
        
                                        # the properties below are optional
                                        optimized_view_port_width="optimizedViewPortWidth"
                                    )
                                )
                            )
                        )
                    )],
                    text_boxes=[quicksight.CfnAnalysis.SheetTextBoxProperty(
                        sheet_text_box_id="sheetTextBoxId",
        
                        # the properties below are optional
                        content="content"
                    )],
                    title="title",
                    visuals=[quicksight.CfnAnalysis.VisualProperty(
                        bar_chart_visual=quicksight.CfnAnalysis.BarChartVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.BarChartConfigurationProperty(
                                bars_arrangement="barsArrangement",
                                category_axis=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                category_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                color_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                contribution_analysis_defaults=[quicksight.CfnAnalysis.ContributionAnalysisDefaultProperty(
                                    contributor_dimensions=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    measure_field_id="measureFieldId"
                                )],
                                data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.BarChartFieldWellsProperty(
                                    bar_chart_aggregated_field_wells=quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty(
                                        category=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        colors=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        small_multiples=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                orientation="orientation",
                                reference_lines=[quicksight.CfnAnalysis.ReferenceLineProperty(
                                    data_configuration=quicksight.CfnAnalysis.ReferenceLineDataConfigurationProperty(
                                        axis_binding="axisBinding",
                                        dynamic_configuration=quicksight.CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty(
                                            calculation=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                    percentile_value=123
                                                ),
                                                simple_numerical_aggregation="simpleNumericalAggregation"
                                            ),
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            measure_aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        static_configuration=quicksight.CfnAnalysis.ReferenceLineStaticDataConfigurationProperty(
                                            value=123
                                        )
                                    ),
        
                                    # the properties below are optional
                                    label_configuration=quicksight.CfnAnalysis.ReferenceLineLabelConfigurationProperty(
                                        custom_label_configuration=quicksight.CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty(
                                            custom_label="customLabel"
                                        ),
                                        font_color="fontColor",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        horizontal_position="horizontalPosition",
                                        value_label_configuration=quicksight.CfnAnalysis.ReferenceLineValueLabelConfigurationProperty(
                                            format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix",
                                                    symbol="symbol"
                                                ),
                                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                ),
                                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                )
                                            ),
                                            relative_position="relativePosition"
                                        ),
                                        vertical_position="verticalPosition"
                                    ),
                                    status="status",
                                    style_configuration=quicksight.CfnAnalysis.ReferenceLineStyleConfigurationProperty(
                                        color="color",
                                        pattern="pattern"
                                    )
                                )],
                                small_multiples_options=quicksight.CfnAnalysis.SmallMultiplesOptionsProperty(
                                    max_visible_columns=123,
                                    max_visible_rows=123,
                                    panel_configuration=quicksight.CfnAnalysis.PanelConfigurationProperty(
                                        background_color="backgroundColor",
                                        background_visibility="backgroundVisibility",
                                        border_color="borderColor",
                                        border_style="borderStyle",
                                        border_thickness="borderThickness",
                                        border_visibility="borderVisibility",
                                        gutter_spacing="gutterSpacing",
                                        gutter_visibility="gutterVisibility",
                                        title=quicksight.CfnAnalysis.PanelTitleOptionsProperty(
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            horizontal_text_alignment="horizontalTextAlignment",
                                            visibility="visibility"
                                        )
                                    )
                                ),
                                sort_configuration=quicksight.CfnAnalysis.BarChartSortConfigurationProperty(
                                    category_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )],
                                    color_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    color_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )],
                                    small_multiples_limit_configuration=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    small_multiples_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )]
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                value_axis=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                value_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        box_plot_visual=quicksight.CfnAnalysis.BoxPlotVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty(
                                box_plot_options=quicksight.CfnAnalysis.BoxPlotOptionsProperty(
                                    all_data_points_visibility="allDataPointsVisibility",
                                    outlier_visibility="outlierVisibility",
                                    style_options=quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty(
                                        fill_style="fillStyle"
                                    )
                                ),
                                category_axis=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                category_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.BoxPlotFieldWellsProperty(
                                    box_plot_aggregated_field_wells=quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty(
                                        group_by=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                primary_yAxis_display_options=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                primary_yAxis_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                reference_lines=[quicksight.CfnAnalysis.ReferenceLineProperty(
                                    data_configuration=quicksight.CfnAnalysis.ReferenceLineDataConfigurationProperty(
                                        axis_binding="axisBinding",
                                        dynamic_configuration=quicksight.CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty(
                                            calculation=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                    percentile_value=123
                                                ),
                                                simple_numerical_aggregation="simpleNumericalAggregation"
                                            ),
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            measure_aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        static_configuration=quicksight.CfnAnalysis.ReferenceLineStaticDataConfigurationProperty(
                                            value=123
                                        )
                                    ),
        
                                    # the properties below are optional
                                    label_configuration=quicksight.CfnAnalysis.ReferenceLineLabelConfigurationProperty(
                                        custom_label_configuration=quicksight.CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty(
                                            custom_label="customLabel"
                                        ),
                                        font_color="fontColor",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        horizontal_position="horizontalPosition",
                                        value_label_configuration=quicksight.CfnAnalysis.ReferenceLineValueLabelConfigurationProperty(
                                            format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix",
                                                    symbol="symbol"
                                                ),
                                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                ),
                                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                )
                                            ),
                                            relative_position="relativePosition"
                                        ),
                                        vertical_position="verticalPosition"
                                    ),
                                    status="status",
                                    style_configuration=quicksight.CfnAnalysis.ReferenceLineStyleConfigurationProperty(
                                        color="color",
                                        pattern="pattern"
                                    )
                                )],
                                sort_configuration=quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty(
                                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )],
                                    pagination_configuration=quicksight.CfnAnalysis.PaginationConfigurationProperty(
                                        page_number=123,
                                        page_size=123
                                    )
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        combo_chart_visual=quicksight.CfnAnalysis.ComboChartVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.ComboChartConfigurationProperty(
                                bar_data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                bars_arrangement="barsArrangement",
                                category_axis=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                category_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                color_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.ComboChartFieldWellsProperty(
                                    combo_chart_aggregated_field_wells=quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty(
                                        bar_values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )],
                                        category=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        colors=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        line_values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                line_data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                primary_yAxis_display_options=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                primary_yAxis_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                reference_lines=[quicksight.CfnAnalysis.ReferenceLineProperty(
                                    data_configuration=quicksight.CfnAnalysis.ReferenceLineDataConfigurationProperty(
                                        axis_binding="axisBinding",
                                        dynamic_configuration=quicksight.CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty(
                                            calculation=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                    percentile_value=123
                                                ),
                                                simple_numerical_aggregation="simpleNumericalAggregation"
                                            ),
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            measure_aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        static_configuration=quicksight.CfnAnalysis.ReferenceLineStaticDataConfigurationProperty(
                                            value=123
                                        )
                                    ),
        
                                    # the properties below are optional
                                    label_configuration=quicksight.CfnAnalysis.ReferenceLineLabelConfigurationProperty(
                                        custom_label_configuration=quicksight.CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty(
                                            custom_label="customLabel"
                                        ),
                                        font_color="fontColor",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        horizontal_position="horizontalPosition",
                                        value_label_configuration=quicksight.CfnAnalysis.ReferenceLineValueLabelConfigurationProperty(
                                            format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix",
                                                    symbol="symbol"
                                                ),
                                                number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    number_scale="numberScale",
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                ),
                                                percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                    decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                        decimal_places=123
                                                    ),
                                                    negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                        display_mode="displayMode"
                                                    ),
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    prefix="prefix",
                                                    separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                        decimal_separator="decimalSeparator",
                                                        thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                            symbol="symbol",
                                                            visibility="visibility"
                                                        )
                                                    ),
                                                    suffix="suffix"
                                                )
                                            ),
                                            relative_position="relativePosition"
                                        ),
                                        vertical_position="verticalPosition"
                                    ),
                                    status="status",
                                    style_configuration=quicksight.CfnAnalysis.ReferenceLineStyleConfigurationProperty(
                                        color="color",
                                        pattern="pattern"
                                    )
                                )],
                                secondary_yAxis_display_options=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                secondary_yAxis_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                sort_configuration=quicksight.CfnAnalysis.ComboChartSortConfigurationProperty(
                                    category_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )],
                                    color_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    color_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )]
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        custom_content_visual=quicksight.CfnAnalysis.CustomContentVisualProperty(
                            data_set_identifier="dataSetIdentifier",
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.CustomContentConfigurationProperty(
                                content_type="contentType",
                                content_url="contentUrl",
                                image_scaling="imageScaling"
                            ),
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        empty_visual=quicksight.CfnAnalysis.EmptyVisualProperty(
                            data_set_identifier="dataSetIdentifier",
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )]
                        ),
                        filled_map_visual=quicksight.CfnAnalysis.FilledMapVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.FilledMapConfigurationProperty(
                                field_wells=quicksight.CfnAnalysis.FilledMapFieldWellsProperty(
                                    filled_map_aggregated_field_wells=quicksight.CfnAnalysis.FilledMapAggregatedFieldWellsProperty(
                                        geospatial=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                map_style_options=quicksight.CfnAnalysis.GeospatialMapStyleOptionsProperty(
                                    base_map_style="baseMapStyle"
                                ),
                                sort_configuration=quicksight.CfnAnalysis.FilledMapSortConfigurationProperty(
                                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )]
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                window_options=quicksight.CfnAnalysis.GeospatialWindowOptionsProperty(
                                    bounds=quicksight.CfnAnalysis.GeospatialCoordinateBoundsProperty(
                                        east=123,
                                        north=123,
                                        south=123,
                                        west=123
                                    ),
                                    map_zoom_mode="mapZoomMode"
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            conditional_formatting=quicksight.CfnAnalysis.FilledMapConditionalFormattingProperty(
                                conditional_formatting_options=[quicksight.CfnAnalysis.FilledMapConditionalFormattingOptionProperty(
                                    shape=quicksight.CfnAnalysis.FilledMapShapeConditionalFormattingProperty(
                                        field_id="fieldId",
        
                                        # the properties below are optional
                                        format=quicksight.CfnAnalysis.ShapeConditionalFormatProperty(
                                            background_color=quicksight.CfnAnalysis.ConditionalFormattingColorProperty(
                                                gradient=quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty(
                                                    color=quicksight.CfnAnalysis.GradientColorProperty(
                                                        stops=[quicksight.CfnAnalysis.GradientStopProperty(
                                                            gradient_offset=123,
        
                                                            # the properties below are optional
                                                            color="color",
                                                            data_value=123
                                                        )]
                                                    ),
                                                    expression="expression"
                                                ),
                                                solid=quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty(
                                                    expression="expression",
        
                                                    # the properties below are optional
                                                    color="color"
                                                )
                                            )
                                        )
                                    )
                                )]
                            ),
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        funnel_chart_visual=quicksight.CfnAnalysis.FunnelChartVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.FunnelChartConfigurationProperty(
                                category_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                data_label_options=quicksight.CfnAnalysis.FunnelChartDataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    label_color="labelColor",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_data_label_style="measureDataLabelStyle",
                                    measure_label_visibility="measureLabelVisibility",
                                    position="position",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.FunnelChartFieldWellsProperty(
                                    funnel_chart_aggregated_field_wells=quicksight.CfnAnalysis.FunnelChartAggregatedFieldWellsProperty(
                                        category=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                sort_configuration=quicksight.CfnAnalysis.FunnelChartSortConfigurationProperty(
                                    category_items_limit=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    category_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )]
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                value_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        gauge_chart_visual=quicksight.CfnAnalysis.GaugeChartVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.GaugeChartConfigurationProperty(
                                data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.GaugeChartFieldWellsProperty(
                                    target_values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                        calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                            expression="expression",
                                            field_id="fieldId"
                                        ),
                                        categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function="aggregationFunction",
                                            format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        ),
                                        date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function="aggregationFunction",
                                            format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                date_time_format="dateTimeFormat",
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        ),
                                        numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                    percentile_value=123
                                                ),
                                                simple_numerical_aggregation="simpleNumericalAggregation"
                                            ),
                                            format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        )
                                    )],
                                    values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                        calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                            expression="expression",
                                            field_id="fieldId"
                                        ),
                                        categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function="aggregationFunction",
                                            format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        ),
                                        date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function="aggregationFunction",
                                            format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                date_time_format="dateTimeFormat",
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        ),
                                        numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId",
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                    percentile_value=123
                                                ),
                                                simple_numerical_aggregation="simpleNumericalAggregation"
                                            ),
                                            format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                    currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix",
                                                        symbol="symbol"
                                                    ),
                                                    number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        number_scale="numberScale",
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    ),
                                                    percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                        decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                            decimal_places=123
                                                        ),
                                                        negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                            display_mode="displayMode"
                                                        ),
                                                        null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                            null_string="nullString"
                                                        ),
                                                        prefix="prefix",
                                                        separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                            decimal_separator="decimalSeparator",
                                                            thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                symbol="symbol",
                                                                visibility="visibility"
                                                            )
                                                        ),
                                                        suffix="suffix"
                                                    )
                                                )
                                            )
                                        )
                                    )]
                                ),
                                gauge_chart_options=quicksight.CfnAnalysis.GaugeChartOptionsProperty(
                                    arc=quicksight.CfnAnalysis.ArcConfigurationProperty(
                                        arc_angle=123,
                                        arc_thickness="arcThickness"
                                    ),
                                    arc_axis=quicksight.CfnAnalysis.ArcAxisConfigurationProperty(
                                        range=quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty(
                                            max=123,
                                            min=123
                                        ),
                                        reserve_range=123
                                    ),
                                    comparison=quicksight.CfnAnalysis.ComparisonConfigurationProperty(
                                        comparison_format=quicksight.CfnAnalysis.ComparisonFormatConfigurationProperty(
                                            number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                    decimal_places=123
                                                ),
                                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                    display_mode="displayMode"
                                                ),
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                number_scale="numberScale",
                                                prefix="prefix",
                                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                    decimal_separator="decimalSeparator",
                                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                        symbol="symbol",
                                                        visibility="visibility"
                                                    )
                                                ),
                                                suffix="suffix"
                                            ),
                                            percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                    decimal_places=123
                                                ),
                                                negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                    display_mode="displayMode"
                                                ),
                                                null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                    null_string="nullString"
                                                ),
                                                prefix="prefix",
                                                separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                    decimal_separator="decimalSeparator",
                                                    thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                        symbol="symbol",
                                                        visibility="visibility"
                                                    )
                                                ),
                                                suffix="suffix"
                                            )
                                        ),
                                        comparison_method="comparisonMethod"
                                    ),
                                    primary_value_display_type="primaryValueDisplayType",
                                    primary_value_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    )
                                ),
                                tooltip_options=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                )
                            ),
                            conditional_formatting=quicksight.CfnAnalysis.GaugeChartConditionalFormattingProperty(
                                conditional_formatting_options=[quicksight.CfnAnalysis.GaugeChartConditionalFormattingOptionProperty(
                                    arc=quicksight.CfnAnalysis.GaugeChartArcConditionalFormattingProperty(
                                        foreground_color=quicksight.CfnAnalysis.ConditionalFormattingColorProperty(
                                            gradient=quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty(
                                                color=quicksight.CfnAnalysis.GradientColorProperty(
                                                    stops=[quicksight.CfnAnalysis.GradientStopProperty(
                                                        gradient_offset=123,
        
                                                        # the properties below are optional
                                                        color="color",
                                                        data_value=123
                                                    )]
                                                ),
                                                expression="expression"
                                            ),
                                            solid=quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty(
                                                expression="expression",
        
                                                # the properties below are optional
                                                color="color"
                                            )
                                        )
                                    ),
                                    primary_value=quicksight.CfnAnalysis.GaugeChartPrimaryValueConditionalFormattingProperty(
                                        icon=quicksight.CfnAnalysis.ConditionalFormattingIconProperty(
                                            custom_condition=quicksight.CfnAnalysis.ConditionalFormattingCustomIconConditionProperty(
                                                expression="expression",
                                                icon_options=quicksight.CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty(
                                                    icon="icon",
                                                    unicode_icon="unicodeIcon"
                                                ),
        
                                                # the properties below are optional
                                                color="color",
                                                display_configuration=quicksight.CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty(
                                                    icon_display_option="iconDisplayOption"
                                                )
                                            ),
                                            icon_set=quicksight.CfnAnalysis.ConditionalFormattingIconSetProperty(
                                                expression="expression",
        
                                                # the properties below are optional
                                                icon_set_type="iconSetType"
                                            )
                                        ),
                                        text_color=quicksight.CfnAnalysis.ConditionalFormattingColorProperty(
                                            gradient=quicksight.CfnAnalysis.ConditionalFormattingGradientColorProperty(
                                                color=quicksight.CfnAnalysis.GradientColorProperty(
                                                    stops=[quicksight.CfnAnalysis.GradientStopProperty(
                                                        gradient_offset=123,
        
                                                        # the properties below are optional
                                                        color="color",
                                                        data_value=123
                                                    )]
                                                ),
                                                expression="expression"
                                            ),
                                            solid=quicksight.CfnAnalysis.ConditionalFormattingSolidColorProperty(
                                                expression="expression",
        
                                                # the properties below are optional
                                                color="color"
                                            )
                                        )
                                    )
                                )]
                            ),
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        geospatial_map_visual=quicksight.CfnAnalysis.GeospatialMapVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.GeospatialMapConfigurationProperty(
                                field_wells=quicksight.CfnAnalysis.GeospatialMapFieldWellsProperty(
                                    geospatial_map_aggregated_field_wells=quicksight.CfnAnalysis.GeospatialMapAggregatedFieldWellsProperty(
                                        colors=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        geospatial=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                map_style_options=quicksight.CfnAnalysis.GeospatialMapStyleOptionsProperty(
                                    base_map_style="baseMapStyle"
                                ),
                                point_style_options=quicksight.CfnAnalysis.GeospatialPointStyleOptionsProperty(
                                    cluster_marker_configuration=quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty(
                                        cluster_marker=quicksight.CfnAnalysis.ClusterMarkerProperty(
                                            simple_cluster_marker=quicksight.CfnAnalysis.SimpleClusterMarkerProperty(
                                                color="color"
                                            )
                                        )
                                    ),
                                    selected_point_style="selectedPointStyle"
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                ),
                                window_options=quicksight.CfnAnalysis.GeospatialWindowOptionsProperty(
                                    bounds=quicksight.CfnAnalysis.GeospatialCoordinateBoundsProperty(
                                        east=123,
                                        north=123,
                                        south=123,
                                        west=123
                                    ),
                                    map_zoom_mode="mapZoomMode"
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        heat_map_visual=quicksight.CfnAnalysis.HeatMapVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.HeatMapConfigurationProperty(
                                color_scale=quicksight.CfnAnalysis.ColorScaleProperty(
                                    color_fill_type="colorFillType",
                                    colors=[quicksight.CfnAnalysis.DataColorProperty(
                                        color="color",
                                        data_value=123
                                    )],
        
                                    # the properties below are optional
                                    null_value_color=quicksight.CfnAnalysis.DataColorProperty(
                                        color="color",
                                        data_value=123
                                    )
                                ),
                                column_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.HeatMapFieldWellsProperty(
                                    heat_map_aggregated_field_wells=quicksight.CfnAnalysis.HeatMapAggregatedFieldWellsProperty(
                                        columns=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        rows=[quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        )],
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                legend=quicksight.CfnAnalysis.LegendOptionsProperty(
                                    height="height",
                                    position="position",
                                    title=quicksight.CfnAnalysis.LabelOptionsProperty(
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        ),
                                        visibility="visibility"
                                    ),
                                    visibility="visibility",
                                    width="width"
                                ),
                                row_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                sort_configuration=quicksight.CfnAnalysis.HeatMapSortConfigurationProperty(
                                    heat_map_column_items_limit_configuration=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    heat_map_column_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )],
                                    heat_map_row_items_limit_configuration=quicksight.CfnAnalysis.ItemsLimitConfigurationProperty(
                                        items_limit=123,
                                        other_categories="otherCategories"
                                    ),
                                    heat_map_row_sort=[quicksight.CfnAnalysis.FieldSortOptionsProperty(
                                        column_sort=quicksight.CfnAnalysis.ColumnSortProperty(
                                            direction="direction",
                                            sort_by=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
        
                                            # the properties below are optional
                                            aggregation_function=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                categorical_aggregation_function="categoricalAggregationFunction",
                                                date_aggregation_function="dateAggregationFunction",
                                                numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                )
                                            )
                                        ),
                                        field_sort=quicksight.CfnAnalysis.FieldSortProperty(
                                            direction="direction",
                                            field_id="fieldId"
                                        )
                                    )]
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                )
                            ),
                            column_hierarchies=[quicksight.CfnAnalysis.ColumnHierarchyProperty(
                                date_time_hierarchy=quicksight.CfnAnalysis.DateTimeHierarchyProperty(
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                explicit_hierarchy=quicksight.CfnAnalysis.ExplicitHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                ),
                                predefined_hierarchy=quicksight.CfnAnalysis.PredefinedHierarchyProperty(
                                    columns=[quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                        column_name="columnName",
                                        data_set_identifier="dataSetIdentifier"
                                    )],
                                    hierarchy_id="hierarchyId",
        
                                    # the properties below are optional
                                    drill_down_filters=[quicksight.CfnAnalysis.DrillDownFilterProperty(
                                        category_filter=quicksight.CfnAnalysis.CategoryDrillDownFilterProperty(
                                            category_values=["categoryValues"],
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            )
                                        ),
                                        numeric_equality_filter=quicksight.CfnAnalysis.NumericEqualityDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            value=123
                                        ),
                                        time_range_filter=quicksight.CfnAnalysis.TimeRangeDrillDownFilterProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            range_maximum="rangeMaximum",
                                            range_minimum="rangeMinimum",
                                            time_granularity="timeGranularity"
                                        )
                                    )]
                                )
                            )],
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        histogram_visual=quicksight.CfnAnalysis.HistogramVisualProperty(
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            chart_configuration=quicksight.CfnAnalysis.HistogramConfigurationProperty(
                                bin_options=quicksight.CfnAnalysis.HistogramBinOptionsProperty(
                                    bin_count=quicksight.CfnAnalysis.BinCountOptionsProperty(
                                        value=123
                                    ),
                                    bin_width=quicksight.CfnAnalysis.BinWidthOptionsProperty(
                                        bin_count_limit=123,
                                        value=123
                                    ),
                                    selected_bin_type="selectedBinType",
                                    start_value=123
                                ),
                                data_labels=quicksight.CfnAnalysis.DataLabelOptionsProperty(
                                    category_label_visibility="categoryLabelVisibility",
                                    data_label_types=[quicksight.CfnAnalysis.DataLabelTypeProperty(
                                        data_path_label_type=quicksight.CfnAnalysis.DataPathLabelTypeProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue",
                                            visibility="visibility"
                                        ),
                                        field_label_type=quicksight.CfnAnalysis.FieldLabelTypeProperty(
                                            field_id="fieldId",
                                            visibility="visibility"
                                        ),
                                        maximum_label_type=quicksight.CfnAnalysis.MaximumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        minimum_label_type=quicksight.CfnAnalysis.MinimumLabelTypeProperty(
                                            visibility="visibility"
                                        ),
                                        range_ends_label_type=quicksight.CfnAnalysis.RangeEndsLabelTypeProperty(
                                            visibility="visibility"
                                        )
                                    )],
                                    label_color="labelColor",
                                    label_content="labelContent",
                                    label_font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                        font_color="fontColor",
                                        font_decoration="fontDecoration",
                                        font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                            relative="relative"
                                        ),
                                        font_style="fontStyle",
                                        font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                            name="name"
                                        )
                                    ),
                                    measure_label_visibility="measureLabelVisibility",
                                    overlap="overlap",
                                    position="position",
                                    visibility="visibility"
                                ),
                                field_wells=quicksight.CfnAnalysis.HistogramFieldWellsProperty(
                                    histogram_aggregated_field_wells=quicksight.CfnAnalysis.HistogramAggregatedFieldWellsProperty(
                                        values=[quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )]
                                    )
                                ),
                                tooltip=quicksight.CfnAnalysis.TooltipOptionsProperty(
                                    field_based_tooltip=quicksight.CfnAnalysis.FieldBasedTooltipProperty(
                                        aggregation_visibility="aggregationVisibility",
                                        tooltip_fields=[quicksight.CfnAnalysis.TooltipItemProperty(
                                            column_tooltip_item=quicksight.CfnAnalysis.ColumnTooltipItemProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
        
                                                # the properties below are optional
                                                aggregation=quicksight.CfnAnalysis.AggregationFunctionProperty(
                                                    categorical_aggregation_function="categoricalAggregationFunction",
                                                    date_aggregation_function="dateAggregationFunction",
                                                    numerical_aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                        percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                            percentile_value=123
                                                        ),
                                                        simple_numerical_aggregation="simpleNumericalAggregation"
                                                    )
                                                ),
                                                label="label",
                                                visibility="visibility"
                                            ),
                                            field_tooltip_item=quicksight.CfnAnalysis.FieldTooltipItemProperty(
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                label="label",
                                                visibility="visibility"
                                            )
                                        )],
                                        tooltip_title_type="tooltipTitleType"
                                    ),
                                    selected_tooltip_type="selectedTooltipType",
                                    tooltip_visibility="tooltipVisibility"
                                ),
                                visual_palette=quicksight.CfnAnalysis.VisualPaletteProperty(
                                    chart_color="chartColor",
                                    color_map=[quicksight.CfnAnalysis.DataPathColorProperty(
                                        color="color",
                                        element=quicksight.CfnAnalysis.DataPathValueProperty(
                                            field_id="fieldId",
                                            field_value="fieldValue"
                                        ),
        
                                        # the properties below are optional
                                        time_granularity="timeGranularity"
                                    )]
                                ),
                                x_axis_display_options=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                ),
                                x_axis_label_options=quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty(
                                    axis_label_options=[quicksight.CfnAnalysis.AxisLabelOptionsProperty(
                                        apply_to=quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty(
                                            column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                column_name="columnName",
                                                data_set_identifier="dataSetIdentifier"
                                            ),
                                            field_id="fieldId"
                                        ),
                                        custom_label="customLabel",
                                        font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                            font_color="fontColor",
                                            font_decoration="fontDecoration",
                                            font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                relative="relative"
                                            ),
                                            font_style="fontStyle",
                                            font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                name="name"
                                            )
                                        )
                                    )],
                                    sort_icon_visibility="sortIconVisibility",
                                    visibility="visibility"
                                ),
                                y_axis_display_options=quicksight.CfnAnalysis.AxisDisplayOptionsProperty(
                                    axis_line_visibility="axisLineVisibility",
                                    axis_offset="axisOffset",
                                    data_options=quicksight.CfnAnalysis.AxisDataOptionsProperty(
                                        date_axis_options=quicksight.CfnAnalysis.DateAxisOptionsProperty(
                                            missing_date_visibility="missingDateVisibility"
                                        ),
                                        numeric_axis_options=quicksight.CfnAnalysis.NumericAxisOptionsProperty(
                                            range=quicksight.CfnAnalysis.AxisDisplayRangeProperty(
                                                data_driven=data_driven,
                                                min_max=quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty(
                                                    maximum=123,
                                                    minimum=123
                                                )
                                            ),
                                            scale=quicksight.CfnAnalysis.AxisScaleProperty(
                                                linear=quicksight.CfnAnalysis.AxisLinearScaleProperty(
                                                    step_count=123,
                                                    step_size=123
                                                ),
                                                logarithmic=quicksight.CfnAnalysis.AxisLogarithmicScaleProperty(
                                                    base=123
                                                )
                                            )
                                        )
                                    ),
                                    grid_line_visibility="gridLineVisibility",
                                    scrollbar_options=quicksight.CfnAnalysis.ScrollBarOptionsProperty(
                                        visibility="visibility",
                                        visible_range=quicksight.CfnAnalysis.VisibleRangeOptionsProperty(
                                            percent_range=quicksight.CfnAnalysis.PercentVisibleRangeProperty(
                                                from=123,
                                                to=123
                                            )
                                        )
                                    ),
                                    tick_label_options=quicksight.CfnAnalysis.AxisTickLabelOptionsProperty(
                                        label_options=quicksight.CfnAnalysis.LabelOptionsProperty(
                                            custom_label="customLabel",
                                            font_configuration=quicksight.CfnAnalysis.FontConfigurationProperty(
                                                font_color="fontColor",
                                                font_decoration="fontDecoration",
                                                font_size=quicksight.CfnAnalysis.FontSizeProperty(
                                                    relative="relative"
                                                ),
                                                font_style="fontStyle",
                                                font_weight=quicksight.CfnAnalysis.FontWeightProperty(
                                                    name="name"
                                                )
                                            ),
                                            visibility="visibility"
                                        ),
                                        rotation_angle=123
                                    )
                                )
                            ),
                            subtitle=quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.LongFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            ),
                            title=quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty(
                                format_text=quicksight.CfnAnalysis.ShortFormatTextProperty(
                                    plain_text="plainText",
                                    rich_text="richText"
                                ),
                                visibility="visibility"
                            )
                        ),
                        insight_visual=quicksight.CfnAnalysis.InsightVisualProperty(
                            data_set_identifier="dataSetIdentifier",
                            visual_id="visualId",
        
                            # the properties below are optional
                            actions=[quicksight.CfnAnalysis.VisualCustomActionProperty(
                                action_operations=[quicksight.CfnAnalysis.VisualCustomActionOperationProperty(
                                    filter_operation=quicksight.CfnAnalysis.CustomActionFilterOperationProperty(
                                        selected_fields_configuration=quicksight.CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty(
                                            selected_field_options="selectedFieldOptions",
                                            selected_fields=["selectedFields"]
                                        ),
                                        target_visuals_configuration=quicksight.CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty(
                                            same_sheet_target_visual_configuration=quicksight.CfnAnalysis.SameSheetTargetVisualConfigurationProperty(
                                                target_visual_options="targetVisualOptions",
                                                target_visuals=["targetVisuals"]
                                            )
                                        )
                                    ),
                                    navigation_operation=quicksight.CfnAnalysis.CustomActionNavigationOperationProperty(
                                        local_navigation_configuration=quicksight.CfnAnalysis.LocalNavigationConfigurationProperty(
                                            target_sheet_id="targetSheetId"
                                        )
                                    ),
                                    set_parameters_operation=quicksight.CfnAnalysis.CustomActionSetParametersOperationProperty(
                                        parameter_value_configurations=[quicksight.CfnAnalysis.SetParameterValueConfigurationProperty(
                                            destination_parameter_name="destinationParameterName",
                                            value=quicksight.CfnAnalysis.DestinationParameterValueConfigurationProperty(
                                                custom_values_configuration=quicksight.CfnAnalysis.CustomValuesConfigurationProperty(
                                                    custom_values=quicksight.CfnAnalysis.CustomParameterValuesProperty(
                                                        date_time_values=["dateTimeValues"],
                                                        decimal_values=[123],
                                                        integer_values=[123],
                                                        string_values=["stringValues"]
                                                    ),
        
                                                    # the properties below are optional
                                                    include_null_value=False
                                                ),
                                                select_all_value_options="selectAllValueOptions",
                                                source_field="sourceField",
                                                source_parameter_name="sourceParameterName"
                                            )
                                        )]
                                    ),
                                    url_operation=quicksight.CfnAnalysis.CustomActionURLOperationProperty(
                                        url_target="urlTarget",
                                        url_template="urlTemplate"
                                    )
                                )],
                                custom_action_id="customActionId",
                                name="name",
                                trigger="trigger",
        
                                # the properties below are optional
                                status="status"
                            )],
                            insight_configuration=quicksight.CfnAnalysis.InsightConfigurationProperty(
                                computations=[quicksight.CfnAnalysis.ComputationProperty(
                                    forecast=quicksight.CfnAnalysis.ForecastComputationProperty(
                                        computation_id="computationId",
                                        time=quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        custom_seasonality_value=123,
                                        lower_boundary=123,
                                        name="name",
                                        periods_backward=123,
                                        periods_forward=123,
                                        prediction_interval=123,
                                        seasonality="seasonality",
                                        upper_boundary=123,
                                        value=quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            date_measure_field=quicksight.CfnAnalysis.DateMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            ),
                                            numerical_measure_field=quicksight.CfnAnalysis.NumericalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function=quicksight.CfnAnalysis.NumericalAggregationFunctionProperty(
                                                    percentile_aggregation=quicksight.CfnAnalysis.PercentileAggregationProperty(
                                                        percentile_value=123
                                                    ),
                                                    simple_numerical_aggregation="simpleNumericalAggregation"
                                                ),
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                )
                                            )
                                        )
                                    ),
                                    growth_rate=quicksight.CfnAnalysis.GrowthRateComputationProperty(
                                        computation_id="computationId",
                                        time=quicksight.CfnAnalysis.DimensionFieldProperty(
                                            categorical_dimension_field=quicksight.CfnAnalysis.CategoricalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            date_dimension_field=quicksight.CfnAnalysis.DateDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                date_granularity="dateGranularity",
                                                format_configuration=quicksight.CfnAnalysis.DateTimeFormatConfigurationProperty(
                                                    date_time_format="dateTimeFormat",
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            ),
                                            numerical_dimension_field=quicksight.CfnAnalysis.NumericalDimensionFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                format_configuration=quicksight.CfnAnalysis.NumberFormatConfigurationProperty(
                                                    format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        ),
                                                        percentage_display_format_configuration=quicksight.CfnAnalysis.PercentageDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix"
                                                        )
                                                    )
                                                ),
                                                hierarchy_id="hierarchyId"
                                            )
                                        ),
        
                                        # the properties below are optional
                                        name="name",
                                        period_size=123,
                                        value=quicksight.CfnAnalysis.MeasureFieldProperty(
                                            calculated_measure_field=quicksight.CfnAnalysis.CalculatedMeasureFieldProperty(
                                                expression="expression",
                                                field_id="fieldId"
                                            ),
                                            categorical_measure_field=quicksight.CfnAnalysis.CategoricalMeasureFieldProperty(
                                                column=quicksight.CfnAnalysis.ColumnIdentifierProperty(
                                                    column_name="columnName",
                                                    data_set_identifier="dataSetIdentifier"
                                                ),
                                                field_id="fieldId",
        
                                                # the properties below are optional
                                                aggregation_function="aggregationFunction",
                                                format_configuration=quicksight.CfnAnalysis.StringFormatConfigurationProperty(
                                                    null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                        null_string="nullString"
                                                    ),
                                                    numeric_format_configuration=quicksight.CfnAnalysis.NumericFormatConfigurationProperty(
                                                        currency_display_format_configuration=quicksight.CfnAnalysis.CurrencyDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            number_scale="numberScale",
                                                            prefix="prefix",
                                                            separator_configuration=quicksight.CfnAnalysis.NumericSeparatorConfigurationProperty(
                                                                decimal_separator="decimalSeparator",
                                                                thousands_separator=quicksight.CfnAnalysis.ThousandSeparatorOptionsProperty(
                                                                    symbol="symbol",
                                                                    visibility="visibility"
                                                                )
                                                            ),
                                                            suffix="suffix",
                                                            symbol="symbol"
                                                        ),
                                                        number_display_format_configuration=quicksight.CfnAnalysis.NumberDisplayFormatConfigurationProperty(
                                                            decimal_places_configuration=quicksight.CfnAnalysis.DecimalPlacesConfigurationProperty(
                                                                decimal_places=123
                                                            ),
                                                            negative_value_configuration=quicksight.CfnAnalysis.NegativeValueConfigurationProperty(
                                                                display_mode="displayMode"
                                                            ),
                                                            null_value_format_configuration=quicksight.CfnAnalysis.NullValueFormatConfigurationProperty(
                                                                null_string="nullString"
                                                            ),
                                                            