import bspump.asab as asab

from .processor import DeclarativeProcessor
from .generator import DeclarativeGenerator
from .timewindowanalyzer import DeclarativeTimeWindowAnalyzer

from .builder import ExpressionBuilder
from .optimizer import ExpressionOptimizer
from .declerror import DeclarationError
from .segmentbuilder import SegmentBuilder

from .abc import Expression
from .abc import SequenceExpression

from .dot import declaration_to_dot, declaration_to_dot_stream


asab.Config.add_defaults(
    {
        "declarations": {
            "timezone": ""  # Default timezone to be used by DATETIME expression, such as Europe/Prague
        }
    }
)


__all__ = [
    "DeclarativeProcessor",
    "DeclarativeGenerator",
    "DeclarativeTimeWindowAnalyzer",
    "ExpressionBuilder",
    "DeclarationError",
    "SegmentBuilder",
    "ExpressionOptimizer",
    "Expression",
    "SequenceExpression",
    "declaration_to_dot",
    "declaration_to_dot_stream",
]
