"""added edgeTemplatesEnabled

Peek Plugin Database Migration Script

Revision ID: 1856b7fb8803
Revises: a86e0317e22a
Create Date: 2019-09-30 16:59:52.193761

"""

# revision identifiers, used by Alembic.
revision = "1856b7fb8803"
down_revision = "a86e0317e22a"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    op.add_column(
        "ModelCoordSet",
        sa.Column(
            "edgeTemplatesEnabled",
            sa.Boolean(),
            nullable=True,
            server_default="false",
        ),
        schema="pl_diagram",
    )
    op.execute(
        """ UPDATE "pl_diagram"."ModelCoordSet"
                   SET "edgeTemplatesEnabled" = false """
    )
    op.alter_column(
        "ModelCoordSet",
        "edgeTemplatesEnabled",
        type_=sa.Boolean(),
        nullable=False,
        schema="pl_diagram",
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("ModelCoordSet", "edgeTemplatesEnabled", schema="pl_diagram")
    # ### end Alembic commands ###
