"""moved smallest sizes to grids

Peek Plugin Database Migration Script

Revision ID: 2127d894e46b
Revises: 6a97dd344aed
Create Date: 2017-08-13 21:31:51.165359

"""

# revision identifiers, used by Alembic.
revision = "2127d894e46b"
down_revision = "6a97dd344aed"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2
from sqlalchemy.dialects import postgresql


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("ModelCoordSet", "smallestTextSize", schema="pl_diagram")

    op.drop_column("ModelCoordSet", "smallestShapeSize", schema="pl_diagram")

    op.add_column(
        "ModelCoordSetGridSize",
        sa.Column(
            "smallestTextSize", sa.Float(), nullable=True, server_default="6.0"
        ),
        schema="pl_diagram",
    )

    op.add_column(
        "ModelCoordSetGridSize",
        sa.Column(
            "smallestShapeSize", sa.Float(), nullable=True, server_default="2.0"
        ),
        schema="pl_diagram",
    )

    op.execute(
        """
    UPDATE "pl_diagram"."ModelCoordSetGridSize"
    SET "smallestShapeSize" = 2.0,
        "smallestTextSize" = 6.0
    """
    )

    op.alter_column(
        "ModelCoordSetGridSize",
        "smallestTextSize",
        existing_type=sa.Float(),
        nullable=False,
        schema="pl_diagram",
    )

    op.alter_column(
        "ModelCoordSetGridSize",
        "smallestShapeSize",
        existing_type=sa.Float(),
        nullable=False,
        schema="pl_diagram",
    )


def downgrade():
    raise NotImplementedError("Downgrade is not implemented")
