"""Fixed importHash indexes for lookups

Peek Plugin Database Migration Script

Revision ID: 9e7ca1acd6be
Revises: 7eed363f5df5
Create Date: 2017-08-12 12:30:43.048362

"""

# revision identifiers, used by Alembic.
revision = "9e7ca1acd6be"
down_revision = "7eed363f5df5"
branch_labels = None
depends_on = None

from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_DispColor_importHash", table_name="DispColor", schema="pl_diagram"
    )
    op.drop_index(
        "idx_DispColor_modelSetId", table_name="DispColor", schema="pl_diagram"
    )

    op.drop_index(
        "idx_DispLayer_modelSetId", table_name="DispLayer", schema="pl_diagram"
    )

    op.drop_index(
        "idx_DispLevel_coordSetId", table_name="DispLevel", schema="pl_diagram"
    )

    op.drop_index(
        "idx_DispLineStyle_importHash",
        table_name="DispLineStyle",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispLineStyle_modelSetId",
        table_name="DispLineStyle",
        schema="pl_diagram",
    )

    op.drop_index(
        "idx_DispTextStyle_importHash",
        table_name="DispTextStyle",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispTextStyle_modelSetId",
        table_name="DispTextStyle",
        schema="pl_diagram",
    )

    op.create_index(
        "idx_DispColor_importHash",
        "DispColor",
        ["modelSetId", "importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispColor_modelSetId",
        "DispColor",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )

    op.create_index(
        "idx_DispLayer_importHash",
        "DispLayer",
        ["modelSetId", "importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLayer_modelSetId",
        "DispLayer",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )

    op.create_index(
        "idx_DispLevel_coordSetId",
        "DispLevel",
        ["coordSetId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLevel_importHash",
        "DispLevel",
        ["coordSetId", "importHash"],
        unique=True,
        schema="pl_diagram",
    )

    op.create_index(
        "idx_DispLineStyle_importHash",
        "DispLineStyle",
        ["modelSetId", "importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispLineStyle_modelSetId",
        "DispLineStyle",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )

    op.create_index(
        "idx_DispTextStyle_importHash",
        "DispTextStyle",
        ["modelSetId", "importHash"],
        unique=True,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispTextStyle_modelSetId",
        "DispTextStyle",
        ["modelSetId"],
        unique=False,
        schema="pl_diagram",
    )
    # ### end Alembic commands ###


def downgrade():
    raise NotImplementedError("Downgrade is not implemented")
