"""background color config

Peek Plugin Database Migration Script

Revision ID: b88c518e8543
Revises: dcc9892e18a8
Create Date: 2023-10-12 13:00:55.942289

"""

# revision identifiers, used by Alembic.
revision = "b88c518e8543"
down_revision = "dcc9892e18a8"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    op.add_column(
        "ModelCoordSet",
        sa.Column(
            "backgroundDarkColor",
            sa.String(),
            nullable=True,
            server_default="#000000",
        ),
        schema="pl_diagram",
    )

    # set 'blockApiUpdate' to false
    op.execute(
        f"""
            UPDATE pl_diagram."ModelCoordSet"
            SET "backgroundDarkColor" = '#000000'
            WHERE "backgroundDarkColor" IS NULL;
    """
    )
    # set 'blockApiUpdate' NOT NULL
    op.alter_column(
        "ModelCoordSet",
        "backgroundDarkColor",
        nullable=False,
        schema="pl_diagram",
    )

    op.add_column(
        "ModelCoordSet",
        sa.Column(
            "backgroundLightColor",
            sa.String(),
            nullable=True,
            server_default="#ffffff",
        ),
        schema="pl_diagram",
    )

    # set 'blockApiUpdate' to false
    op.execute(
        f"""
            UPDATE pl_diagram."ModelCoordSet"
            SET "backgroundLightColor" = '#ffffff'
            WHERE "backgroundLightColor" IS NULL;
        """
    )
    # set 'blockApiUpdate' NOT NULL
    op.alter_column(
        "ModelCoordSet",
        "backgroundLightColor",
        nullable=False,
        schema="pl_diagram",
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("ModelCoordSet", "backgroundDarkColor", schema="pl_diagram")
    op.drop_column("ModelCoordSet", "backgroundLightColor", schema="pl_diagram")
    # ### end Alembic commands ###
