"""Removed BranchGridIndex

Peek Plugin Database Migration Script

Revision ID: bf8f559c4df9
Revises: 4f6ed1047562
Create Date: 2019-05-11 15:55:51.316969

"""

# revision identifiers, used by Alembic.
revision = "bf8f559c4df9"
down_revision = "4f6ed1047562"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_BranchGridIndex_coord_key",
        table_name="BranchGridIndex",
        schema="pl_diagram",
    )
    op.drop_table("BranchGridIndex", schema="pl_diagram")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "BranchGridIndex",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text(
                "nextval('pl_diagram.\"BranchGridIndex_id_seq\"'::regclass)"
            ),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "branchIndexId", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column(
            "coordSetId", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column("gridKey", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["branchIndexId"],
            ["pl_diagram.BranchIndex.id"],
            name="BranchGridIndex_branchIndexId_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["coordSetId"],
            ["pl_diagram.ModelCoordSet.id"],
            name="BranchGridIndex_coordSetId_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint(
            "id", "coordSetId", name="BranchGridIndex_pkey"
        ),
        schema="pl_diagram",
    )
    op.create_index(
        "idx_BranchGridIndex_coord_key",
        "BranchGridIndex",
        ["coordSetId", "branchIndexId", "gridKey"],
        unique=True,
        schema="pl_diagram",
    )
    # ### end Alembic commands ###
