"""make light mode optional

Peek Plugin Database Migration Script

Revision ID: c579df20f0f8
Revises: b88c518e8543
Create Date: 2023-10-12 14:07:37.315132

"""

# revision identifiers, used by Alembic.
revision = "c579df20f0f8"
down_revision = "b88c518e8543"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    op.add_column(
        "ModelCoordSet",
        sa.Column(
            "lightModeEnabled",
            sa.Boolean(),
            nullable=True,
            server_default="true",
        ),
        schema="pl_diagram",
    )

    # set 'blockApiUpdate' to false
    op.execute(
        f"""
                UPDATE pl_diagram."ModelCoordSet"
                SET "lightModeEnabled" = true
                WHERE "lightModeEnabled" IS NULL;
            """
    )
    # set 'blockApiUpdate' NOT NULL
    op.alter_column(
        "ModelCoordSet", "lightModeEnabled", nullable=False, schema="pl_diagram"
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("ModelCoordSet", "lightModeEnabled", schema="pl_diagram")
    # ### end Alembic commands ###
