"""Added edgeColor removed lu indexes

Peek Plugin Database Migration Script

Revision ID: da424430bf97
Revises: 473d5f6a97e8
Create Date: 2019-06-30 16:24:37.618354

"""

# revision identifiers, used by Alembic.
revision = "da424430bf97"
down_revision = "473d5f6a97e8"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_DispEllipse_fillColorId",
        table_name="DispEllipse",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispEllipse_lineColorId",
        table_name="DispEllipse",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispEllipse_lineStyleId",
        table_name="DispEllipse",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispPolygon_fillColorId",
        table_name="DispPolygon",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispPolygon_lineColorId",
        table_name="DispPolygon",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispPolygon_lineStyleId",
        table_name="DispPolygon",
        schema="pl_diagram",
    )
    op.add_column(
        "DispPolyline",
        sa.Column("edgeColorId", sa.Integer(), nullable=True),
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispPolyline_lineColorId",
        table_name="DispPolyline",
        schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispPolyline_lineStyleId",
        table_name="DispPolyline",
        schema="pl_diagram",
    )
    op.create_foreign_key(
        "DispGroupPointer_edgeColorId_fkey",
        "DispPolyline",
        "DispColor",
        ["edgeColorId"],
        ["id"],
        source_schema="pl_diagram",
        referent_schema="pl_diagram",
    )
    op.drop_index(
        "idx_DispText_colorId", table_name="DispText", schema="pl_diagram"
    )
    op.drop_index(
        "idx_DispText_styleId", table_name="DispText", schema="pl_diagram"
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "idx_DispText_styleId",
        "DispText",
        ["textStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispText_colorId",
        "DispText",
        ["colorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.drop_constraint(
        "DispGroupPointer_edgeColorId_fkey",
        "DispPolyline",
        schema="pl_diagram",
        type_="foreignkey",
    )
    op.create_index(
        "idx_DispPolyline_lineStyleId",
        "DispPolyline",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolyline_lineColorId",
        "DispPolyline",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.drop_column("DispPolyline", "edgeColorId", schema="pl_diagram")
    op.create_index(
        "idx_DispPolygon_lineStyleId",
        "DispPolygon",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolygon_lineColorId",
        "DispPolygon",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispPolygon_fillColorId",
        "DispPolygon",
        ["fillColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_lineStyleId",
        "DispEllipse",
        ["lineStyleId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_lineColorId",
        "DispEllipse",
        ["lineColorId"],
        unique=False,
        schema="pl_diagram",
    )
    op.create_index(
        "idx_DispEllipse_fillColorId",
        "DispEllipse",
        ["fillColorId"],
        unique=False,
        schema="pl_diagram",
    )
    # ### end Alembic commands ###
