"""add layer opacity

Peek Plugin Database Migration Script

Revision ID: ebcb7ce2ed21
Revises: c579df20f0f8
Create Date: 2023-10-12 14:36:00.091998

"""

# revision identifiers, used by Alembic.
revision = "ebcb7ce2ed21"
down_revision = "c579df20f0f8"
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    op.add_column(
        "DispLayer",
        sa.Column("opacity", sa.Float(), nullable=True, server_default="1.0"),
        schema="pl_diagram",
    )

    # set 'blockApiUpdate' to false
    op.execute(
        f"""
                UPDATE pl_diagram."DispLayer"
                SET "opacity" = 1.0
                WHERE "opacity" IS NULL;
            """
    )
    # set 'blockApiUpdate' NOT NULL
    op.alter_column("DispLayer", "opacity", nullable=False, schema="pl_diagram")


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("DispLayer", "opacity", schema="pl_diagram")
    # ### end Alembic commands ###
