import logging
import sys
from unittest import TestCase


class WorkerDiagramGridApiImpl(TestCase):
    def setUp(self):
        # setup for `PeekPlatformConfig.config.bashLocation`
        logging.basicConfig(
            stream=sys.stdout,
            format="%(asctime)s %(levelname)s %(name)s:%(message)s",
            datefmt="%d-%b-%Y %H:%M:%S",
            level=logging.DEBUG,
        )
        from peek_platform import PeekPlatformConfig

        from peek_plugin_base.PeekVortexUtil import peekWorkerName

        PeekPlatformConfig.componentName = peekWorkerName

        # The config depends on the componentName, order is important
        from peek_worker_service.PeekWorkerConfig import PeekWorkerConfig

        PeekPlatformConfig.config = PeekWorkerConfig()

        # setup for `TaskDbConn`
        from peek_plugin_base.worker.task_db_conn import TaskDbConn

        TaskDbConn._dbConnectString = PeekPlatformConfig.config.dbConnectString
        TaskDbConn._dbEngineArgs = PeekPlatformConfig.config.dbEngineArgs

    # Disabled, this needs specific data
    def _test_getGridKeysFromShapeKeys_All(self):
        from .WorkerDiagramGridApiImpl import WorkerDiagramGridApiImpl

        result = WorkerDiagramGridApiImpl.getGridKeyTuplesFromShapeKeys(
            "pofDiagram", "Distribution World", testKeys
        )
        self.assertTrue(result)
        print(result)

    # Disabled, this needs specific data
    def _test_getGridKeysFromShapeKeys_Smallest(self):
        from .WorkerDiagramGridApiImpl import WorkerDiagramGridApiImpl

        result = WorkerDiagramGridApiImpl.getGridKeyTuplesFromShapeKeys(
            "pofDiagram", "Distribution World", testKeys
        )
        self.assertTrue(result)
        print(result)

    # Disabled, this needs specific data
    def _test_filterShapesByShapeKey(self):
        from peek_plugin_diagram._private.worker.api.WorkerDiagramGridApiImpl import (
            WorkerDiagramGridApiImpl,
        )

        WorkerDiagramGridApiImpl._DEBUG_LOGGING = True

        gridKeyTuples = WorkerDiagramGridApiImpl.getGridKeys(
            "pofDiagram", "Distribution World"
        )[:50]
        self.assertTrue(gridKeyTuples)

        decodedCompiledGridTuples = (
            WorkerDiagramGridApiImpl.getShapesByGridKeys(
                [g.gridKey for g in gridKeyTuples]
            )
        )
        self.assertTrue(decodedCompiledGridTuples)

        traceKeys = set(testKeys)
        for decodedCompiledGridTuple in decodedCompiledGridTuples.values():
            print(f"running for {decodedCompiledGridTuple.gridKey}")
            print(
                str(
                    [
                        s.get("k")
                        for s in decodedCompiledGridTuple.shapes
                        if s.get("k") and s.get("g")
                    ]
                )
            )
            decodedCompiledGridTuple.shapes = (
                WorkerDiagramGridApiImpl.filterShapesByShapeKey(
                    decodedCompiledGridTuple.shapes, traceKeys
                )
            )


testKeys = [
    "k00020aa6COMP",
    "k00020b68COMP",
    "k0001a7cbCOMP",
    "k0001a846COMP",
    "k0001a87eCOMP",
    "k0001a705COMP",
    "k0001a902COMP",
    "k0001a848COMP",
    "k0001a87fCOMP",
    "k0001a8f8COMP",
    "k0001a901COMP",
    "k0001a8a1COMP",
    "k00020b2cCOMP",
    "k00020b15COMP",
    "k00020a7dCOMP",
    "k00020b22COMP",
    "k0001a82bCOMP",
    "k00020b7aCOMP",
    "k00020acbCOMP",
    "k00020b74COMP",
    "k00020af0COMP",
    "k00020afeCOMP",
    "k00020b96COMP",
    "k00020b3aCOMP",
    "k00020b57COMP",
    "k0001a864COMP",
    "k0001a582COMP",
    "k0007db66HOT",
    "k0001a429COMP",
    "k0007daedHOT",
    "k0001a43bCOMP",
    "k0007daf6HOT",
    "k000207a6COMP",
    "e0001b43eHOT",
    "k000207a5COMP",
    "e0001b43dHOT",
    "k000207a8COMP",
    "e00018fc1HOT",
    "k000207a9COMP",
    "e00018fc2HOT",
    "k000207acCOMP",
    "k0002070aCOMP",
    "e0001263eHOT",
    "k000206f4COMP",
    "e0001263fHOT",
    "k000206f8COMP",
    "e00012640HOT",
    "k0006c0beCOMP",
    "k000a1881COMP",
    "k0006bf89HOT",
    "k000a18bbCOMP",
    "k0006bf8aHOT",
    "k000a1a17COMP",
    "k0006bf8bHOT",
    "k000a12e7COMP",
    "k00069a3bHOT",
    "k000a19ccCOMP",
    "k00069d55HOT",
    "k000a1607COMP",
    "k00069bb4HOT",
    "k000a175cCOMP",
    "k00069c29HOT",
    "k000a19f3COMP",
    "k00069d67HOT",
    "k000a16baCOMP",
    "k00069bf7HOT",
    "k000a1333COMP",
    "k00069a5cHOT",
    "k000a1817COMP",
    "k00069c84HOT",
    "k000a1463COMP",
    "k00069aeeHOT",
    "k000a157bCOMP",
    "k00069b76HOT",
    "k000a19ceCOMP",
    "k00069d56HOT",
    "k000a18beCOMP",
    "k00069cdcHOT",
    "k000a1577COMP",
    "k00069b74HOT",
    "k000a1994COMP",
    "k00069d34HOT",
    "k000a15f8COMP",
    "k00069bacHOT",
    "k000a15b4COMP",
    "k00069b90HOT",
    "k000a12baCOMP",
    "k00069a21HOT",
    "k000a1940COMP",
    "k00069d10HOT",
    "k000a12d8COMP",
    "k00069a32HOT",
    "k000a1869COMP",
    "k00069cb1HOT",
    "k000a16f8COMP",
    "k00069c05HOT",
    "k000a1619COMP",
    "k00069bbcHOT",
    "k000a1860COMP",
    "k00069cabHOT",
    "k000a1550COMP",
    "k00069b5fHOT",
    "k000a1a07COMP",
    "k00069d73HOT",
    "k000a1455COMP",
    "k00069ae9HOT",
    "k000a1867COMP",
    "k00069cb0HOT",
    "k000a128fCOMP",
    "k00069a06HOT",
    "k000a158cCOMP",
    "k00069b80HOT",
    "k000a1798COMP",
    "k00069c49HOT",
    "k000a1914COMP",
    "k00069d02HOT",
    "k000a178cCOMP",
    "k00069c42HOT",
    "k000a1549COMP",
    "k00069b59HOT",
    "k000a16e8COMP",
    "k00069c03HOT",
    "k000a19c1COMP",
    "k00069d4eHOT",
    "k000a18bcCOMP",
    "k00069cdaHOT",
    "k000a1379COMP",
    "k00069a7dHOT",
    "k000a13ffCOMP",
    "k00069abdHOT",
    "k000a18b2COMP",
    "k00069cd7HOT",
    "k000a125eCOMP",
    "k000699f4HOT",
    "k000a1570COMP",
    "k00069b70HOT",
    "k000a171fCOMP",
    "k00069c17HOT",
    "k000a19a5COMP",
    "k00069d3eHOT",
    "k000a14c5COMP",
    "k00069b21HOT",
    "k000a12aeCOMP",
    "k00069a17HOT",
    "k000a1403COMP",
    "k00069ac0HOT",
    "k000a1983COMP",
    "k00069d2cHOT",
    "k000a1520COMP",
    "k00069b48HOT",
    "k000a1563COMP",
    "k00069b6bHOT",
    "k000a26cfCOMP",
    "k0006bfb6HOT",
    "k000a2705COMP",
    "k0006bfb7HOT",
    "k000a2756COMP",
    "k0006bfb8HOT",
    "k000a2799COMP",
    "k0006bfb9HOT",
    "k000a27e1COMP",
    "k0006bfbaHOT",
    "k000a28c3COMP",
    "k0006bfbbHOT",
    "k000a28f1COMP",
    "k0006bfbcHOT",
    "k000a1ad2COMP",
    "k0006bf8cHOT",
    "k000a1ad3COMP",
    "k0006bf8dHOT",
    "k000a1b4fCOMP",
    "k0006bf8eHOT",
    "k000a1b50COMP",
    "k0006bf8fHOT",
    "k000a1b5eCOMP",
    "k0006bf90HOT",
    "k000a1b5fCOMP",
    "k0006bf91HOT",
    "k000a1bbcCOMP",
    "k0006bf92HOT",
    "k000a1bbdCOMP",
    "k0006bf93HOT",
    "k000a1c07COMP",
    "k0006bf94HOT",
    "k000a1d11COMP",
    "k0006bf95HOT",
    "k000a1d88COMP",
    "k0006bf96HOT",
    "k000a1dc4COMP",
    "k0006bf97HOT",
    "k000a1dc5COMP",
    "k0006bf98HOT",
    "k000a1de4COMP",
    "k0006bf99HOT",
    "k000a1de8COMP",
    "k0006bf9aHOT",
    "k000a1de9COMP",
    "k0006bf9bHOT",
    "k000a1e25COMP",
    "k0006bf9cHOT",
    "k000a1e53COMP",
    "k0006bf9dHOT",
    "k000a1e9dCOMP",
    "k0006bf9eHOT",
    "k000a1f0cCOMP",
    "k0006bf9fHOT",
    "k000a1f19COMP",
    "k0006bfa0HOT",
    "k000a1fbaCOMP",
    "k0006bfa1HOT",
    "k000a2002COMP",
    "k0006bfa2HOT",
    "k000a200aCOMP",
    "k0006bfa3HOT",
    "k000a2097COMP",
    "k0006bfa4HOT",
    "k000a2098COMP",
    "k0006bfa5HOT",
    "k000a20d4COMP",
    "k0006bfa6HOT",
    "k000a216bCOMP",
    "k0006bfa7HOT",
    "k000a21afCOMP",
    "k0006bfa8HOT",
    "k000a2323COMP",
    "k0006bfa9HOT",
    "k000a2419COMP",
    "k0006bfaaHOT",
    "k000a249cCOMP",
    "k0006bfabHOT",
    "k000a24ecCOMP",
    "k0006bfacHOT",
    "k000a24f3COMP",
    "k0006bfadHOT",
    "k000a253dCOMP",
    "k0006bfaeHOT",
    "k000a2588COMP",
    "k0006bfafHOT",
    "k000a25c3COMP",
    "k0006bfb0HOT",
    "k000a25e1COMP",
    "k0006bfb1HOT",
    "k000a263fCOMP",
    "k0006bfb2HOT",
    "k000a266bCOMP",
    "k0006bfb4HOT",
    "k000a2682COMP",
    "k0006bfb5HOT",
    "k000a1c7cCOMP",
    "k00069e5fHOT",
    "k000a2385COMP",
    "k0006a07aHOT",
    "k000a1c12COMP",
    "k00069e3fHOT",
    "k000a1d0aCOMP",
    "k00069e93HOT",
    "k000a1b1cCOMP",
    "k00069deaHOT",
    "k000a1ab1COMP",
    "k00069db7HOT",
    "k000a1be3COMP",
    "k00069e2aHOT",
    "k000a1e1bCOMP",
    "k00069ef4HOT",
    "k000a240eCOMP",
    "k0006a099HOT",
    "k000a1fadCOMP",
    "k00069f6fHOT",
    "k000a1facCOMP",
    "k00069f6eHOT",
    "k000a2019COMP",
    "k00069f93HOT",
    "k000a1f8cCOMP",
    "k00069f63HOT",
    "k000a2041COMP",
    "k00069fa2HOT",
    "k000a1be4COMP",
    "k00069e2bHOT",
    "k000a1fdaCOMP",
    "k00069f80HOT",
    "k000a208dCOMP",
    "k00069fb5HOT",
    "k000a1b2cCOMP",
    "k00069df0HOT",
    "k000a2070COMP",
    "k00069fadHOT",
    "k000a214fCOMP",
    "k00069fe8HOT",
    "k000a2000COMP",
    "k00069f8aHOT",
    "k000a21e9COMP",
    "k0006a013HOT",
    "k000a1d09COMP",
    "k00069e92HOT",
    "k000a1cfcCOMP",
    "k00069e8dHOT",
    "k000a22c2COMP",
    "k0006a04aHOT",
    "k000a27a6COMP",
    "k0006a147HOT",
    "k000a2614COMP",
    "k0006a109HOT",
    "k000a1be8COMP",
    "k00069e2cHOT",
    "k000a26aaCOMP",
    "k0006a121HOT",
    "k000a1a65COMP",
    "k00069d9cHOT",
    "k000a1e63COMP",
    "k00069f0dHOT",
    "k000a1ed9COMP",
    "k00069f2dHOT",
    "k000a27a5COMP",
    "k0006a146HOT",
    "k000a213eCOMP",
    "k00069fe5HOT",
    "k000a2274COMP",
    "k0006a034HOT",
    "k000a1e4aCOMP",
    "k00069f04HOT",
    "k000a2440COMP",
    "k0006a0a8HOT",
    "k000a213dCOMP",
    "k00069fe4HOT",
    "k000a1c2fCOMP",
    "k00069e4eHOT",
    "k000a1cb6COMP",
    "k00069e75HOT",
    "k000a1b92COMP",
    "k00069e11HOT",
    "k000a1e7cCOMP",
    "k00069f14HOT",
    "k000a226cCOMP",
    "k0006a031HOT",
    "k000a1c67COMP",
    "k00069e5aHOT",
    "k000a1d86COMP",
    "k00069ebcHOT",
    "k000a2613COMP",
    "k0006a108HOT",
    "k000a1f9eCOMP",
    "k00069f69HOT",
    "k000a22c1COMP",
    "k0006a049HOT",
    "k000a1cb9COMP",
    "k00069e77HOT",
    "k000a1b2bCOMP",
    "k00069defHOT",
    "k000a25d2COMP",
    "k0006a0faHOT",
    "k000a2620COMP",
    "k0006a10cHOT",
    "k000a1c11COMP",
    "k00069e3eHOT",
    "k000a26abCOMP",
    "k0006a122HOT",
    "k000a1af6COMP",
    "k00069dd7HOT",
    "k000a1f3dCOMP",
    "k00069f4fHOT",
    "k000a2345COMP",
    "k0006a06bHOT",
    "k000a21c8COMP",
    "k0006a00bHOT",
    "k000a1b8cCOMP",
    "k00069e0fHOT",
    "k000a1c62COMP",
    "k00069e59HOT",
    "k000a21a9COMP",
    "k0006a004HOT",
    "k000a2423COMP",
    "k0006a0a0HOT",
    "k000a2590COMP",
    "k0006a0ebHOT",
    "k000a26d2COMP",
    "k0006a129HOT",
    "k000a2567COMP",
    "k0006a0e5HOT",
    "k000a1b8dCOMP",
    "k00069e10HOT",
    "k000a1e4bCOMP",
    "k00069f05HOT",
    "k000a2549COMP",
    "k0006a0dfHOT",
    "k000a1dbdCOMP",
    "k00069ed0HOT",
    "k000a1af5COMP",
    "k00069dd6HOT",
    "k000a23ddCOMP",
    "k0006a08cHOT",
    "k000a2531COMP",
    "k0006a0ddHOT",
    "k000a20ceCOMP",
    "k00069fc9HOT",
    "k000a2611COMP",
    "k0006a107HOT",
    "k000a238bCOMP",
    "k0006a07cHOT",
    "k000a201aCOMP",
    "k00069f94HOT",
    "k000a1d93COMP",
    "k00069ec0HOT",
    "k000a1dfeCOMP",
    "k00069eeaHOT",
    "k000a1cb8COMP",
    "k00069e76HOT",
    "k000a1b1bCOMP",
    "k00069de9HOT",
    "k000a1d5dCOMP",
    "k00069eaeHOT",
    "k000a1f38COMP",
    "k00069f4dHOT",
    "k000a1be9COMP",
    "k00069e2dHOT",
    "k000a1e9fCOMP",
    "k00069f1cHOT",
    "k000a1ab0COMP",
    "k00069db6HOT",
    "k000a2530COMP",
    "k0006a0dcHOT",
    "k000a1c7bCOMP",
    "k00069e5eHOT",
    "k000a2909COMP",
    "k0006a16eHOT",
    "k000a2674COMP",
    "k0006a11bHOT",
    "k000a23dcCOMP",
    "k0006a08bHOT",
    "k000a1d40COMP",
    "k00069ea8HOT",
    "k000a1dfdCOMP",
    "k00069ee9HOT",
    "k000a26c4COMP",
    "k0006a127HOT",
    "k000a2641COMP",
    "k0006a110HOT",
    "k000a2640COMP",
    "k000a249dCOMP",
    "k000a221dCOMP",
    "k000a24edCOMP",
    "k000a2900COMP",
    "k000a216cCOMP",
    "k000a23eaCOMP",
    "k000a282aCOMP",
    "k000a1f0dCOMP",
    "k000a26b4COMP",
    "k000a279cCOMP",
    "k000a282cCOMP",
    "k000a28c4COMP",
    "k000a2744COMP",
    "k000a20d1COMP",
    "k000a20eaCOMP",
    "k000a200bCOMP",
    "k000a15adCOMP",
    "k000a2640COMP",
    "k000a1fdbCOMP",
    "k000a26afCOMP",
    "k000a2997COMP",
    "k000a26aeCOMP",
    "k000a2568COMP",
    "k000a1c86COMP",
    "k000a2071COMP",
    "k000a1b97COMP",
    "k000a28f3COMP",
    "k000a15a6COMP",
    "k000a1d87COMP",
    "k000a1ebeCOMP",
    "k000a1dbeCOMP",
    "k000a254aCOMP",
    "k000a1239COMP",
    "k000a1f6dCOMP",
    "k000a1a66COMP",
    "k000a27e4COMP",
    "k000a2089COMP",
    "k000a164cCOMP",
    "k000a2042COMP",
    "k000a2998COMP",
    "k000a2958COMP",
    "k000a2115COMP",
    "k000a1bf2COMP",
    "k000a2469COMP",
    "k000a244aCOMP",
    "k000a24f5COMP",
    "k000a2727COMP",
    "k000a1f9fCOMP",
    "k000a2675COMP",
    "k000a287bCOMP",
    "k000a26bdCOMP",
    "k000a14beCOMP",
    "k000a27e8COMP",
    "k000a26deCOMP",
    "k000a1c63COMP",
    "k000a2875COMP",
    "k000a297dCOMP",
    "k000a228fCOMP",
    "k000a2438COMP",
    "k000a2421COMP",
    "k000a22e9COMP",
    "k000a26afCOMP",
    "k000a2982COMP",
    "k000a1b88COMP",
    "k000a2990COMP",
    "k000a2591COMP",
    "k000a27e3COMP",
    "k000a1f07COMP",
    "k000a2731COMP",
    "k000a288bCOMP",
    "k000a1e4eCOMP",
    "k000a1576COMP",
    "k000a1cecCOMP",
    "k000a1e64COMP",
    "k000a1f3eCOMP",
    "k000a208eCOMP",
    "k000a1d8bCOMP",
    "k000a1c68COMP",
    "k000a140fCOMP",
    "k000a2758COMP",
    "k000a238cCOMP",
    "k000a192fCOMP",
    "k00069d09HOT",
    "k000a1354COMP",
    "k00069a68HOT",
    "k000a0cd1COMP",
    "e0001a6bbHOT",
    "k000a0cd2COMP",
    "e0001a6bcHOT",
    "k000a0d28COMP",
    "e0001a589HOT",
    "k000a0d29COMP",
    "e0001a58aHOT",
    "k000a0dc5COMP",
    "e0001a5d2HOT",
    "k000a0dc4COMP",
    "e0001a5d1HOT",
    "k000a0bcfCOMP",
    "e0001a62fHOT",
    "k000a0bd0COMP",
    "e0001a630HOT",
    "k000a0c3cCOMP",
    "e0001a67aHOT",
    "k000a0c3bCOMP",
    "e0001a679HOT",
    "k000a0c5fCOMP",
    "e0001a689HOT",
    "k000a0c60COMP",
    "e0001a68aHOT",
    "k000a0ca2COMP",
    "e0001a6acHOT",
    "k000a0ca1COMP",
    "e0001a6abHOT",
    "k000a1931COMP",
    "k00069d0aHOT",
    "k000a1930COMP",
    "k00069d08HOT",
    "k000a1356COMP",
    "k00069a69HOT",
    "k000a1355COMP",
    "k00069a67HOT",
    "k000a15a9COMP",
    "k0006bf72HOT",
    "k000a15aaCOMP",
    "k0006bf71HOT",
    "k000a15a8COMP",
    "k0006bf73HOT",
    "k000a14bbCOMP",
    "k00069b1bHOT",
    "k000a14baCOMP",
    "k00069b1cHOT",
    "k000a14b9COMP",
    "k00069b1dHOT",
    "k000a1236COMP",
    "k000699dbHOT",
    "k000a1234COMP",
    "k000699ddHOT",
    "k000a1235COMP",
    "k000699dcHOT",
    "k000a1573COMP",
    "k00069b71HOT",
    "k000a1572COMP",
    "k00069b72HOT",
    "k000a1571COMP",
    "k00069b73HOT",
    "k000a15a1COMP",
    "k00069b8eHOT",
    "k000a15a3COMP",
    "k00069b8cHOT",
    "k000a15a2COMP",
    "k00069b8dHOT",
    "k000a1649COMP",
    "k00069bc9HOT",
    "k000a1647COMP",
    "k00069bcbHOT",
]
