# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 prefetch: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] account: The account for API operations.
        :param pulumi.Input[_builtins.bool] prefetch: Flag to enable the prefetch of zone records.
        :param pulumi.Input[_builtins.bool] sandbox: Flag to enable the sandbox API.
        :param pulumi.Input[_builtins.str] token: The API v2 token for API operations.
        :param pulumi.Input[_builtins.str] user_agent: Custom string to append to the user agent used for sending HTTP requests to the API.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if prefetch is not None:
            pulumi.set(__self__, "prefetch", prefetch)
        if sandbox is not None:
            pulumi.set(__self__, "sandbox", sandbox)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account for API operations.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def prefetch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable the prefetch of zone records.
        """
        return pulumi.get(self, "prefetch")

    @prefetch.setter
    def prefetch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prefetch", value)

    @_builtins.property
    @pulumi.getter
    def sandbox(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable the sandbox API.
        """
        return pulumi.get(self, "sandbox")

    @sandbox.setter
    def sandbox(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sandbox", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API v2 token for API operations.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom string to append to the user agent used for sending HTTP requests to the API.
        """
        return pulumi.get(self, "user_agent")

    @user_agent.setter
    def user_agent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_agent", value)


@pulumi.type_token("pulumi:providers:dnsimple")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 prefetch: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the dnsimple package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: The account for API operations.
        :param pulumi.Input[_builtins.bool] prefetch: Flag to enable the prefetch of zone records.
        :param pulumi.Input[_builtins.bool] sandbox: Flag to enable the sandbox API.
        :param pulumi.Input[_builtins.str] token: The API v2 token for API operations.
        :param pulumi.Input[_builtins.str] user_agent: Custom string to append to the user agent used for sending HTTP requests to the API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the dnsimple package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 prefetch: Optional[pulumi.Input[_builtins.bool]] = None,
                 sandbox: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["prefetch"] = pulumi.Output.from_input(prefetch).apply(pulumi.runtime.to_json) if prefetch is not None else None
            __props__.__dict__["sandbox"] = pulumi.Output.from_input(sandbox).apply(pulumi.runtime.to_json) if sandbox is not None else None
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["user_agent"] = user_agent
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'dnsimple',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account for API operations.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API v2 token for API operations.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom string to append to the user agent used for sending HTTP requests to the API.
        """
        return pulumi.get(self, "user_agent")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:dnsimple/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

