<a id="mypy-boto3-opsworks"></a>

# mypy-boto3-opsworks

[![PyPI - mypy-boto3-opsworks](https://img.shields.io/pypi/v/mypy-boto3-opsworks.svg?color=blue)](https://pypi.org/project/mypy-boto3-opsworks)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-opsworks.svg?color=blue)](https://pypi.org/project/mypy-boto3-opsworks)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-opsworks?color=blue)](https://pypistats.org/packages/mypy-boto3-opsworks)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.OpsWorks 1.17.94](https://boto3.amazonaws.com/v1/documentation/api/1.17.94/reference/services/opsworks.html#OpsWorks)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.18.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-opsworks docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opsworks/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-opsworks](#mypy-boto3-opsworks)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `OpsWorks` service.

```bash
python -m pip install boto3-stubs[opsworks]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[opsworks]` in your environment:
  `python -m pip install 'boto3-stubs[opsworks]'`

Both type checking and auto-complete should work for `OpsWorks` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[opsworks]` in your environment:
  `python -m pip install 'boto3-stubs[opsworks]'`

Both type checking and auto-complete should work for `OpsWorks` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[opsworks]` in your environment:
  `python -m pip install 'boto3-stubs[opsworks]'`
- Run `mypy` as usual

Type checking should work for `OpsWorks` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[opsworks]` in your environment:
  `python -m pip install 'boto3-stubs[opsworks]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `OpsWorks` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`OpsWorksClient` provides annotations for `boto3.client("opsworks")`.

```python
import boto3

from mypy_boto3_opsworks import OpsWorksClient

client: OpsWorksClient = boto3.client("opsworks")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: OpsWorksClient = session.client("opsworks")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_opsworks.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_opsworks import OpsWorksClient
from mypy_boto3_opsworks.paginator import (
    DescribeEcsClustersPaginator,
)

client: OpsWorksClient = boto3.client("opsworks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_ecs_clusters_paginator: DescribeEcsClustersPaginator = client.get_paginator("describe_ecs_clusters")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_opsworks.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_opsworks import OpsWorksClient
from mypy_boto3_opsworks.waiter import (
    AppExistsWaiter,
    DeploymentSuccessfulWaiter,
    InstanceOnlineWaiter,
    InstanceRegisteredWaiter,
    InstanceStoppedWaiter,
    InstanceTerminatedWaiter,
)

client: OpsWorksClient = boto3.client("opsworks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
app_exists_waiter: AppExistsWaiter = client.get_waiter("app_exists")
deployment_successful_waiter: DeploymentSuccessfulWaiter = client.get_waiter("deployment_successful")
instance_online_waiter: InstanceOnlineWaiter = client.get_waiter("instance_online")
instance_registered_waiter: InstanceRegisteredWaiter = client.get_waiter("instance_registered")
instance_stopped_waiter: InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`OpsWorksServiceResource` provides annotations for
`boto3.resource("opsworks")`.

```python
from mypy_boto3_opsworks import OpsWorksServiceResource

resource: OpsWorksServiceResource = boto3.resource("opsworks")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: OpsWorksServiceResource = session.resource("opsworks")
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_opsworks.service_resource` module contains type annotations for all
resources.

```python
from mypy_boto3_opsworks import OpsWorksServiceResource
from mypy_boto3_opsworks.service_resource import (
    Layer,
    Stack,
    StackSummary,
)

resource: OpsWorksServiceResource = boto3.resource("opsworks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_layer: Layer = resource.Layer(...)
my_stack: Stack = resource.Stack(...)
my_stack_summary: StackSummary = resource.StackSummary(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_opsworks.service_resource` module contains type annotations for all
`OpsWorksServiceResource` collections.

```python
from mypy_boto3_opsworks import OpsWorksServiceResource
from mypy_boto3_opsworks.service_resource import (
    ServiceResourceStacksCollection,
)

resource: OpsWorksServiceResource = boto3.resource("opsworks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
stacks: opsworks_resources.ServiceResourceStacksCollection = resource.stacks
```

<a id="literals"></a>

### Literals

`mypy_boto3_opsworks.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_opsworks.literals import (
    AppAttributesKeysType,
    AppExistsWaiterName,
    AppTypeType,
    ArchitectureType,
    AutoScalingTypeType,
    CloudWatchLogsEncodingType,
    CloudWatchLogsInitialPositionType,
    CloudWatchLogsTimeZoneType,
    DeploymentCommandNameType,
    DeploymentSuccessfulWaiterName,
    DescribeEcsClustersPaginatorName,
    InstanceOnlineWaiterName,
    InstanceRegisteredWaiterName,
    InstanceStoppedWaiterName,
    InstanceTerminatedWaiterName,
    LayerAttributesKeysType,
    LayerTypeType,
    RootDeviceTypeType,
    SourceTypeType,
    StackAttributesKeysType,
    VirtualizationTypeType,
    VolumeTypeType,
)

def check_value(value: AppAttributesKeysType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_opsworks.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_opsworks.type_defs import (
    AgentVersionTypeDef,
    AppTypeDef,
    AutoScalingThresholdsTypeDef,
    BlockDeviceMappingTypeDef,
    ChefConfigurationTypeDef,
    CloneStackResultTypeDef,
    CloudWatchLogsConfigurationTypeDef,
    CloudWatchLogsLogStreamTypeDef,
    CommandTypeDef,
    CreateAppResultTypeDef,
    CreateDeploymentResultTypeDef,
    CreateInstanceResultTypeDef,
    CreateLayerResultTypeDef,
    CreateStackResultTypeDef,
    CreateUserProfileResultTypeDef,
    DataSourceTypeDef,
    DeploymentCommandTypeDef,
    DeploymentTypeDef,
    DescribeAgentVersionsResultTypeDef,
    DescribeAppsResultTypeDef,
    DescribeCommandsResultTypeDef,
    DescribeDeploymentsResultTypeDef,
    DescribeEcsClustersResultTypeDef,
    DescribeElasticIpsResultTypeDef,
    DescribeElasticLoadBalancersResultTypeDef,
    DescribeInstancesResultTypeDef,
    DescribeLayersResultTypeDef,
    DescribeLoadBasedAutoScalingResultTypeDef,
    DescribeMyUserProfileResultTypeDef,
    DescribeOperatingSystemsResponseTypeDef,
    DescribePermissionsResultTypeDef,
    DescribeRaidArraysResultTypeDef,
    DescribeRdsDbInstancesResultTypeDef,
    DescribeServiceErrorsResultTypeDef,
    DescribeStackProvisioningParametersResultTypeDef,
    DescribeStackSummaryResultTypeDef,
    DescribeStacksResultTypeDef,
    DescribeTimeBasedAutoScalingResultTypeDef,
    DescribeUserProfilesResultTypeDef,
    DescribeVolumesResultTypeDef,
    EbsBlockDeviceTypeDef,
    EcsClusterTypeDef,
    ElasticIpTypeDef,
    ElasticLoadBalancerTypeDef,
    EnvironmentVariableTypeDef,
    GetHostnameSuggestionResultTypeDef,
    GrantAccessResultTypeDef,
    InstanceIdentityTypeDef,
    InstanceTypeDef,
    InstancesCountTypeDef,
    LayerTypeDef,
    LifecycleEventConfigurationTypeDef,
    ListTagsResultTypeDef,
    LoadBasedAutoScalingConfigurationTypeDef,
    OperatingSystemConfigurationManagerTypeDef,
    OperatingSystemTypeDef,
    PaginatorConfigTypeDef,
    PermissionTypeDef,
    RaidArrayTypeDef,
    RdsDbInstanceTypeDef,
    RecipesTypeDef,
    RegisterEcsClusterResultTypeDef,
    RegisterElasticIpResultTypeDef,
    RegisterInstanceResultTypeDef,
    RegisterVolumeResultTypeDef,
    ReportedOsTypeDef,
    SelfUserProfileTypeDef,
    ServiceErrorTypeDef,
    ShutdownEventConfigurationTypeDef,
    SourceTypeDef,
    SslConfigurationTypeDef,
    StackConfigurationManagerTypeDef,
    StackSummaryTypeDef,
    StackTypeDef,
    TemporaryCredentialTypeDef,
    TimeBasedAutoScalingConfigurationTypeDef,
    UserProfileTypeDef,
    VolumeConfigurationTypeDef,
    VolumeTypeDef,
    WaiterConfigTypeDef,
    WeeklyAutoScalingScheduleTypeDef,
)

def get_structure() -> AgentVersionTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-opsworks` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-opsworks docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opsworks/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
