# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Optional
from typing_extensions import Required, Annotated, TypedDict

from ..._utils import PropertyInfo

__all__ = ["RowUpdateParams", "Config"]


class RowUpdateParams(TypedDict, total=False):
    inference_id: Required[Annotated[str, PropertyInfo(alias="inferenceId")]]
    """Specify the inference id as a query param."""

    row: Required[object]

    config: Optional[Config]


class Config(TypedDict, total=False):
    ground_truth_column_name: Annotated[Optional[str], PropertyInfo(alias="groundTruthColumnName")]
    """Name of the column with the ground truths."""

    human_feedback_column_name: Annotated[Optional[str], PropertyInfo(alias="humanFeedbackColumnName")]
    """Name of the column with human feedback."""

    inference_id_column_name: Annotated[Optional[str], PropertyInfo(alias="inferenceIdColumnName")]
    """Name of the column with the inference ids.

    This is useful if you want to update rows at a later point in time. If not
    provided, a unique id is generated by Openlayer.
    """

    latency_column_name: Annotated[Optional[str], PropertyInfo(alias="latencyColumnName")]
    """Name of the column with the latencies."""

    timestamp_column_name: Annotated[Optional[str], PropertyInfo(alias="timestampColumnName")]
    """Name of the column with the timestamps.

    Timestamps must be in UNIX sec format. If not provided, the upload timestamp is
    used.
    """
