# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .dns_answer_flag_ids import DnsAnswerFlagIds
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class DnsAnswer(UncheckedBaseModel):
    """
    The DNS Answer object represents a specific response provided by the Domain Name System (DNS) when querying for information about a domain or performing a DNS operation. It encapsulates the relevant details and data returned by the DNS server in response to a query.
    """

    class_: typing.Optional[str] = pydantic.Field(alias="class", default=None)
    """
    The class of DNS data contained in this resource record. See <a target='_blank' href='https://www.rfc-editor.org/rfc/rfc1035.txt'>RFC1035</a>. For example: <code>IN</code>.
    """

    flag_ids: typing.Optional[typing.List[DnsAnswerFlagIds]] = pydantic.Field(
        default=None
    )
    """
    The list of DNS answer header flag IDs.
    """

    flags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of DNS answer header flags.
    """

    packet_uid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.
    """

    rdata: str = pydantic.Field()
    """
    The data describing the DNS resource. The meaning of this data depends on the type and class of the resource record.
    """

    ttl: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time interval that the resource record may be cached. Zero value means that the resource record can only be used for the transaction in progress, and should not be cached.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of data contained in this resource record. See <a target='_blank' href='https://www.rfc-editor.org/rfc/rfc1035.txt'>RFC1035</a>. For example: <code>CNAME</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
