# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .reputation_score_id import ReputationScoreId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Reputation(UncheckedBaseModel):
    """
    The Reputation object describes the reputation/risk score of an entity (e.g. device, user, domain).
    """

    base_score: float = pydantic.Field()
    """
    The reputation score as reported by the event source.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provider of the reputation information.
    """

    score: typing.Optional[str] = pydantic.Field(default=None)
    """
    The reputation score, normalized to the caption of the score_id value. In the case of 'Other', it is defined by the event source.
    """

    score_id: ReputationScoreId = pydantic.Field()
    """
    The normalized reputation score identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
