# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
from .activity_id import ActivityId
import pydantic
import typing
from ...objects.types.actor import Actor
from ...objects.types.api import Api
from .category_uid import CategoryUid
from .class_uid import ClassUid
from ...objects.types.cloud import Cloud
from ...objects.types.object import Object
from ...objects.types.device import Device
from ...objects.types.network_endpoint import NetworkEndpoint
from ...objects.types.email import Email
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...objects.types.enrichment import Enrichment
from ...objects.types.file import File
from ...objects.types.http_request import HttpRequest
from ...objects.types.http_response import HttpResponse
from ...objects.types.meeting import Meeting
from ...objects.types.messaging import Messaging
from ...objects.types.metadata import Metadata
from ...objects.types.observable import Observable
from ...objects.types.osint import Osint
from .severity_id import SeverityId
from ...objects.types.sharing import Sharing
from ...objects.types.product import Product
from .status_id import StatusId
from ...objects.types.tls import Tls
from .type_uid import TypeUid
from ...objects.types.web_resource import WebResource
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class CloudActivity(UncheckedBaseModel):
    """
    Cloud activity events report events and actions logged or collected from a cloud environment. This class is based on Web Resources Activity, but is more broad and suited to event logs with diverse types of data available.
    """

    activity_id: ActivityId = pydantic.Field()
    """
    The normalized identifier of the activity that triggered the event.
    """

    activity_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event activity name, as defined by the activity_id.
    """

    actor: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    The actor which initiated or caused the action or event, as used in 3001/Account Change.
    """

    api: typing.Optional[Api] = pydantic.Field(default=None)
    """
    Describes details about a typical API (Application Programming Interface) call.
    """

    category_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event category name, as defined by category_uid value: <code>Application Activity</code>.
    """

    category_uid: CategoryUid = pydantic.Field()
    """
    The category unique identifier of the event.
    """

    class_uid: ClassUid = pydantic.Field()
    """
    The unique identifier of a class. A class describes the attributes available in an event.
    """

    cloud: typing.Optional[Cloud] = pydantic.Field(default=None)
    """
    Describes details about the Cloud environment where the event was originally created or logged.
    """

    count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of times that events in the same logical group occurred during the event <strong>Start Time</strong> to <strong>End Time</strong> period.
    """

    custom_fields: typing.Optional[Object] = pydantic.Field(default=None)
    """
    A list of custom fields
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    The device which was used by the user to cause the event, or which the event is otherwise about or related to.
    """

    dst_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Details about server providing the web resources.
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    The event duration or aggregate time, the amount of time the event covers from <code>start_time</code> to <code>end_time</code> in milliseconds.
    """

    email: typing.Optional[Email] = pydantic.Field(default=None)
    """
    An email which related to the event, such as a mail that was sent, scanned, or caused by the event.
    """

    end_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The end time of a time period, or the time of the most recent event included in the aggregate event.
    """

    end_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The end time of a time period, or the time of the most recent event included in the aggregate event.
    """

    enrichments: typing.Optional[typing.List[Enrichment]] = pydantic.Field(default=None)
    """
    The additional information from an external data source, which is associated with the event or a finding. For example add location information for the IP address in the DNS answers:</p><code>[{"name": "answers.ip", "value": "92.24.47.250", "type": "location", "data": {"city": "Socotra", "continent": "Asia", "coordinates": [-25.4153, 17.0743], "country": "YE", "desc": "Yemen"}}]</code>
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    The file which is related to the event, such as an uploaded, downloaded, deleted, or modified file.
    """

    http_request: typing.Optional[HttpRequest] = pydantic.Field(default=None)
    """
    Details about the underlying HTTP request.
    """

    http_response: typing.Optional[HttpResponse] = pydantic.Field(default=None)
    """
    Details about the HTTP response, if available.
    """

    meeting: typing.Optional[Meeting] = pydantic.Field(default=None)
    """
    Information relating to a meeting, such as attendees, start/end times, and meeting details.
    """

    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the event/finding, as defined by the source.
    """

    messaging: typing.Optional[Messaging] = pydantic.Field(default=None)
    """
    Information related to instant messaging, such as sending messages, adding users to channels, etc.
    """

    metadata: Metadata = pydantic.Field()
    """
    The metadata associated with the event or a finding.
    """

    observables: typing.Optional[typing.List[Observable]] = pydantic.Field(default=None)
    """
    The observables associated with the event or a finding.
    """

    osint: typing.Optional[typing.List[Osint]] = pydantic.Field(default=None)
    """
    The OSINT (Open Source Intelligence) object contains details related to an indicator such as the indicator itself, related indicators, geolocation, registrar information, subdomains, analyst commentary, and other contextual information. This information can be used to further enrich a detection or finding by providing decisioning support to other analysts and engineers.
    """

    parameters: typing.Optional[Object] = pydantic.Field(default=None)
    """
    A place to store parameters which were passed to a command, application, program, etc. This could include CLI parameters, the configuration used to launch an app, etc.
    """

    raw_data: typing.Optional[str] = pydantic.Field(default=None)
    """
    The raw event/finding data as received from the source.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event/finding severity, normalized to the caption of the severity_id value. In the case of 'Other', it is defined by the source.
    """

    severity_id: SeverityId = pydantic.Field()
    """
    <p>The normalized identifier of the event/finding severity.</p>The normalized severity is a measurement the effort and expense required to manage and resolve an event or incident. Smaller numerical values represent lower impact events, and larger numerical values represent higher impact events.
    """

    sharing: typing.Optional[Sharing] = pydantic.Field(default=None)
    """
    Information about how and with whom a resource was shared, such as sharing permissions and scope.
    """

    src_app: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The app which initiated or caused an action or event, such as the client.
    """

    src_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Details about the endpoint from which the request originated.
    """

    start_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The start time of a time period, or the time of the least recent event included in the aggregate event.
    """

    start_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The start time of a time period, or the time of the least recent event included in the aggregate event.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event status, normalized to the caption of the status_id value. In the case of 'Other', it is defined by the event source.
    """

    status_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event status code, as reported by the event source.<br /><br />For example, in a Windows Failed Authentication event, this would be the value of 'Failure Code', e.g. 0x18.
    """

    status_detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    The status detail contains additional information about the event/finding outcome.
    """

    status_id: typing.Optional[StatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the event status.
    """

    target_app: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The app which is the target of the action or event. For example, when a user adds an app to Teams, the app which was added would be the target app, and Teams would be the source app.
    """

    time: Timestamp = pydantic.Field()
    """
    The normalized event occurrence time or the finding creation time.
    """

    time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The normalized event occurrence time or the finding creation time.
    """

    timezone_offset: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of minutes that the reported event <code>time</code> is ahead or behind UTC, in the range -1,080 to +1,080.
    """

    tls: typing.Optional[Tls] = pydantic.Field(default=None)
    """
    The Transport Layer Security (TLS) attributes, if available.
    """

    type_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event/finding type name, as defined by the type_uid.
    """

    type_uid: TypeUid = pydantic.Field()
    """
    The event/finding type ID. It identifies the event's semantics and structure. The value is calculated by the logging system as: <code>class_uid \* 100 + activity_id</code>.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the event schema. The names and values of those attributes are specific to the event source.
    """

    web_resources: typing.List[WebResource] = pydantic.Field()
    """
    Describes details about web resources that were affected by an activity/event.
    """

    web_resources_result: typing.Optional[typing.List[WebResource]] = pydantic.Field(
        default=None
    )
    """
    The results of the activity on web resources. It should contain the new values of the changed attributes of the web resources.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
