# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .kb_article import KbArticle
import pydantic
from .compliance_status_id import ComplianceStatusId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Compliance(UncheckedBaseModel):
    """
    The Compliance object contains information about Industry and Regulatory Framework standards, controls and requirements.
    """

    compliance_references: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of sources of information or tools that help organizations understand, interpret, and implement compliance standards. They provide guidance, best practices, and examples.
    """

    compliance_standards: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of established guidelines or criteria that define specific requirements an organization must follow.
    """

    control: typing.Optional[str] = pydantic.Field(default=None)
    """
    A Control is prescriptive, prioritized, and simplified set of best practices that one can use to strengthen their cybersecurity posture. e.g. AWS SecurityHub Controls, CIS Controls.
    """

    requirements: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of requirements associated to a specific control in an industry or regulatory framework. e.g. <code> NIST.800-53.r5 AU-10 </code>
    """

    standards: typing.List[str] = pydantic.Field()
    """
    Security standards are a set of criteria organizations can follow to protect sensitive and confidential information. e.g. <code>NIST SP 800-53, CIS AWS Foundations Benchmark v1.4.0, ISO/IEC 27001</code>
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resultant status of the compliance check normalized to the caption of the <code>status_id</code> value. In the case of 'Other', it is defined by the event source.
    """

    status_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resultant status code of the compliance check.
    """

    status_detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contextual description of the status, status_code values.
    """

    status_id: typing.Optional[ComplianceStatusId] = pydantic.Field(default=None)
    """
    The normalized status identifier of the compliance check.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
