# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .group import Group
import pydantic
from .request import Request
from .response import Response
from .service import Service
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Api(UncheckedBaseModel):
    """
    The API, or Application Programming Interface, object represents information pertaining to an API request and response.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The information pertaining to the API group.
    """

    operation: str = pydantic.Field()
    """
    Verb/Operation associated with the request
    """

    request: typing.Optional[Request] = pydantic.Field(default=None)
    """
    Details pertaining to the API request.
    """

    response: typing.Optional[Response] = pydantic.Field(default=None)
    """
    Details pertaining to the API response.
    """

    service: typing.Optional[Service] = pydantic.Field(default=None)
    """
    The information pertaining to the API service.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the API service.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
