# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .container import Container
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Response(UncheckedBaseModel):
    """
    The Response Elements object describes characteristics of an API response.
    """

    code: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric response sent to a request.
    """

    containers: typing.Optional[typing.List[Container]] = pydantic.Field(default=None)
    """
    When working with containerized applications, the set of containers which write to the standard the output of a particular logging driver. For example, this may be the set of containers involved in handling api requests and responses for a containerized application.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The additional data that is associated with the api response.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error Code
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error Message
    """

    flags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of communication flags, normalized to the captions of the flag_ids values. In the case of 'Other', they are defined by the event source.
    """

    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the event/finding, as defined by the source.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
