# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .dns_answer import DnsAnswer
import pydantic
from .attack import Attack
from .autonomous_system import AutonomousSystem
from .osint_confidence_id import OsintConfidenceId
from .email import Email
from .email_auth import EmailAuth
from .kill_chain_phase import KillChainPhase
from .location import Location
from .digital_signature import DigitalSignature
from ...base.types.url_string import UrlString
from .osint_tlp import OsintTlp
from .osint_type_id import OsintTypeId
from .vulnerability import Vulnerability
from .whois import Whois
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Osint(UncheckedBaseModel):
    """
    The OSINT (Open Source Intelligence) object contains details related to an indicator such as the indicator itself, related indicators, geolocation, registrar information, subdomains, analyst commentary, and other contextual information. This information can be used to further enrich a detection or finding by providing decisioning support to other analysts and engineers.
    """

    answers: typing.Optional[typing.List[DnsAnswer]] = pydantic.Field(default=None)
    """
    Any pertinent DNS answers information related to an indicator or OSINT analysis.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    MITRE ATT&CK Tactics, Techniques, and/or Procedures (TTPs) pertinent to an indicator or OSINT analysis.
    """

    autonomous_system: typing.Optional[AutonomousSystem] = pydantic.Field(default=None)
    """
    Any pertinent autonomous system information related to an indicator or OSINT analysis.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Analyst commentary or source commentary about an indicator or OSINT analysis.
    """

    confidence: typing.Optional[str] = pydantic.Field(default=None)
    """
    The confidence of an indicator being malicious and/or pertinent, normalized to the caption of the confidence_id value. In the case of 'Other', it is defined by the event source or analyst.
    """

    confidence_id: typing.Optional[OsintConfidenceId] = pydantic.Field(default=None)
    """
    The normalized confidence refers to the accuracy of collected information related to the OSINT or how pertinent an indicator or analysis is to a specific event or finding. A low confidence means that the information collected or analysis conducted lacked detail or is not accurate enough to qualify an indicator as fully malicious.
    """

    email: typing.Optional[Email] = pydantic.Field(default=None)
    """
    Any email information pertinent to an indicator or OSINT analysis.
    """

    email_auth: typing.Optional[EmailAuth] = pydantic.Field(default=None)
    """
    Any email authentication information pertinent to an indicator or OSINT analysis.
    """

    kill_chain: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(
        default=None
    )
    """
    Lockheed Martin Kill Chain Phases pertinent to an indicator or OSINT analysis.
    """

    location: typing.Optional[Location] = pydantic.Field(default=None)
    """
    Any pertinent geolocation information related to an indicator or OSINT analysis.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the entity.
    """

    signatures: typing.Optional[typing.List[DigitalSignature]] = pydantic.Field(
        default=None
    )
    """
    Any digital signatures or hashes related to an indicator or OSINT analysis.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The source URL of an indicator or OSINT analysis, e.g., a URL back to a TIP, report, or otherwise.
    """

    subdomains: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Any pertinent subdomain information - such as those generated by a Domain Generation Algorithm - related to an indicator or OSINT analysis.
    """

    tlp: typing.Optional[OsintTlp] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://www.first.org/tlp/'>Traffic Light Protocol</a> was created to facilitate greater sharing of potentially sensitive information and more effective collaboration. TLP provides a simple and intuitive schema for indicating with whom potentially sensitive information can be shared.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The OSINT indicator type.
    """

    type_id: OsintTypeId = pydantic.Field()
    """
    The OSINT indicator type ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the entity.
    """

    value: str = pydantic.Field()
    """
    The actual indicator value in scope, e.g., a SHA-256 hash hexdigest or a domain name.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor name of a tool which generates intelligence or provides indicators.
    """

    vulnerabilities: typing.Optional[typing.List[Vulnerability]] = pydantic.Field(
        default=None
    )
    """
    Any vulnerabilities related to an indicator or OSINT analysis.
    """

    whois: typing.Optional[Whois] = pydantic.Field(default=None)
    """
    Any pertinent WHOIS information related to an indicator or OSINT analysis.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
