# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .scan_type_id import ScanTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Scan(UncheckedBaseModel):
    """
    The Scan object describes characteristics of a proactive scan.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The administrator-supplied or application-generated name of the scan. For example: "Home office weekly user database scan", "Scan folders for viruses", "Full system virus scan"
    """

    targets: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Hosts or IP addresses targeted by the scan.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of scan.
    """

    type_id: ScanTypeId = pydantic.Field()
    """
    The type id of the scan.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The application-defined unique identifier assigned to an instance of a scan.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
