# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .malware_classification_ids import MalwareClassificationIds
import pydantic
from .cve import Cve
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Malware(UncheckedBaseModel):
    """
    The Malware object describes the classification of known malicious software, which is intentionally designed to cause damage to a computer, server, client, or computer network.
    """

    classification_ids: typing.List[MalwareClassificationIds] = pydantic.Field()
    """
    The list of normalized identifiers of the malware classifications. Reference: <a target='_blank' href='https://docs.oasis-open.org/cti/stix/v2.1/os/stix-v2.1-os.html#_oxlc4df65spl'>STIX Malware Types</a>
    """

    classifications: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of malware classifications, normalized to the captions of the <code>classification_ids</code> values. In the case of 'Other', they are defined by the event source.
    """

    cves: typing.Optional[typing.List[Cve]] = pydantic.Field(default=None)
    """
    List of Common Vulnerabilities and Exposures (<a target='_blank' href='https://cve.mitre.org/'>CVE</a>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The malware name, as reported by the detection engine.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The filesystem path of the malware that was observed.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provider of the malware information.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The malware unique identifier, as reported by the detection engine. For example a virus id or an IPS signature id.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
