# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .attack import Attack
import pydantic
from .kill_chain_phase import KillChainPhase
from .observable import Observable
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class RelatedEvent(UncheckedBaseModel):
    """
    The Related Event object describes an OCSF event related to a finding.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    An array of <a target='_blank' href='https://attack.mitre.org'>MITRE ATT&CK®</a> objects describing the tactics, techniques & sub-techniques identified by a security control or finding.
    """

    kill_chain: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(
        default=None
    )
    """
    The <a target='_blank' href='https://www.lockheedmartin.com/en-us/capabilities/cyber/cyber-kill-chain.html'>Cyber Kill Chain®</a> provides a detailed description of each phase and its associated activities within the broader context of a cyber attack.
    """

    observables: typing.Optional[typing.List[Observable]] = pydantic.Field(default=None)
    """
    The observables associated with the event or a finding.
    """

    product_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the product that reported the related event.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the related event, as defined by <code>type_uid</code>. <p>For example: <code>Process Activity: Launch.</code></p>
    """

    type_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the related OCSF event, as defined by <code>type_uid</code>. <p>For example: <code>Process Activity: Launch.</code></p>
    """

    type_uid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unique identifier of the related OCSF event type. <p>For example: <code>100701.</code></p>
    """

    uid: str = pydantic.Field()
    """
    The unique identifier of the related OCSF event. This value must be equal to <code>metadata.uid</code> in the corresponding related event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
