# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Organization(UncheckedBaseModel):
    """
    The Organization object describes characteristics of an organization or company and its division if any. Additionally, it also describes cloud and Software-as-a-Service (SaaS) logical hierarchies such as AWS Organizations, Google Cloud Organizations, Oracle Cloud Tenancies, and similar constructs.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization, Oracle Cloud Tenancy, Google Cloud Organization, or AWS Organization. For example, <code> Widget, Inc. </code> or the <code> AWS Organization name </code>.
    """

    ou_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of an organizational unit, Google Cloud Folder, or AWS Org Unit. For example, the <code> GCP Project Name </code>, or <code> Dev_Prod_OU </code>.
    """

    ou_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of an organizational unit, Google Cloud Folder, or AWS Org Unit. For example, an <code> Oracle Cloud Tenancy ID </code>, <code> AWS OU ID </code>, or <code> GCP Folder ID </code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the organization, Oracle Cloud Tenancy, Google Cloud Organization, or AWS Organization. For example, an <code> AWS Org ID </code> or <code> Oracle Cloud Domain ID </code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
