# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .malware_scan_info_type_id import MalwareScanInfoTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class MalwareScanInfo(UncheckedBaseModel):
    """
    The malware scan information object describes characteristics, metadata of a malware scanning job.
    """

    end_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp indicating when the scan job completed execution.
    """

    end_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp indicating when the scan job completed execution.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The administrator-supplied or application-generated name of the scan. For example: "Home office weekly user database scan", "Scan folders for viruses", "Full system virus scan"
    """

    num_files: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of files analyzed during the scan.
    """

    num_infected: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of files identified as infected with malware during the scan.
    """

    num_volumes: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of storage volumes examined during the malware scan.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total size in bytes of all files that were scanned.
    """

    start_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp indicating when the scan job began execution.
    """

    start_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp indicating when the scan job began execution.
    """

    targets: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Hosts or IP addresses targeted by the scan.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of scan.
    """

    type_id: MalwareScanInfoTypeId = pydantic.Field()
    """
    The type id of the scan.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The application-defined unique identifier assigned to an instance of a scan.
    """

    unique_malware_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of unique malware detected across all infected files.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
